context('plotHistogram()')

# remove Rplots.pdf created by ggplot2
on.exit( tryCatch({ file.remove('./Rplots.pdf') }, error=function(e){ invisible() }, warning=function(w){ invisible() }) )


## Input data
tmp_val1 <- c(10.644293, 9.177798, 10.393417, 9.447590, 10.022506, 8.389317, 11.623143, 11.020120, 9.639020, 10.670132, 8.526128, 8.619795, 10.798778, 8.669350, 10.625186, 9.593496, 10.522484, 9.015953, 8.794898, 10.620957, 10.554719, 10.226229, 10.475357, 9.992459, 11.113836, 11.352681, 9.388116, 9.670468, 10.367398, 11.096113, 8.628743, 7.447648, 11.206125, 10.834777, 11.442105, 10.426603, 9.382197, 12.015874, 10.138830, 10.084652, 8.033009, 10.706276, 8.914247, 11.565550, 10.741636, 9.935142, 8.946637, 8.185505, 11.117803, 11.571063, 9.325529, 9.873617, 8.941858, 8.549300, 9.243888, 9.404607, 10.255570, 9.051812, 9.596695, 10.178016, 8.814194, 9.229914, 9.381140, 10.255375, 11.505189, 10.519921, 10.562517, 9.407024, 11.230320, 10.172108, 9.153026, 10.191618, 9.921504, 9.737902, 10.266193, 7.815468, 10.589246, 10.894356, 8.333499, 9.749672, 10.703478, 9.792935, 9.696380, 10.510474, 10.372886, 9.714139, 9.898624, 10.848782, 9.497278, 10.221973, 10.444204, 10.090630, 9.203229, 10.512323, 9.802430, 12.343919, 11.143281, 9.798212, 9.698939, 9.398902, 10.587625, 10.636354, 9.230380, 9.957588, 10.418188, 9.279189, 9.974051, 9.247993, 9.484029, 11.001487, 11.506798, 9.772260, 11.298511, 9.609622, 9.963613, 9.380601, 10.844662, 9.491576, 10.073848, 11.908335, 7.896677, 10.462259, 10.959859, 10.380787, 8.485465, 8.223324, 9.812014, 10.662467, 10.540096, 10.573985, 10.798064, 9.023030, 8.573901, 9.795164, 10.573003, 10.165271, 11.005525, 8.942668, 10.328424, 9.424616, 9.932867, 9.953211, 9.225184, 9.669337, 8.679496, 11.407803, 7.168406, 9.581974, 8.401034, 10.933280, 7.778268, 12.732782, 10.157371, 10.973452, 10.953142, 9.302671, 9.299618, 9.790544, 8.531828, 10.619425, 12.390289, 9.786206, 9.196165, 10.439081, 9.975673, 7.436526, 11.752134, 9.715867, 10.806319, 9.456504, 9.083147, 11.264049, 10.159344, 8.424040, 9.691892, 10.948871, 10.714110, 10.613067, 10.110629, 10.170468, 12.427481, 10.714230, 10.354024, 12.885606, 12.260397, 10.263737, 10.990817, 9.720313, 10.442335, 10.686345, 10.229379, 10.022657, 10.650094, 7.868164, 9.789534, 11.372671, 10.074151, 11.151042, 10.321009, 8.882168, 11.034173, 9.691333, 12.166846, 10.056928, 9.490134, 11.781234, 10.278611, 10.876681, 9.304108, 11.559844, 9.929265, 10.595372, 9.174646, 9.291423, 9.667239, 9.339406, 10.338140, 9.579804, 11.300812, 10.385785, 10.715334, 9.717628, 10.727854, 10.319962, 10.586837, 9.546920, 9.559250, 11.233138, 10.907385, 11.327739, 8.681815, 8.274462, 10.196321, 9.974067, 9.544998, 8.941550, 9.029286, 10.116472, 11.197125, 12.220394, 10.008310, 9.918042, 10.541192, 8.222705, 9.260825, 11.045866, 11.180266, 12.387770, 11.749522, 11.332142, 11.301761, 8.543155, 10.395296, 9.800328, 8.622309, 11.327787, 9.857356, 11.304018, 10.360669, 8.101515, 9.667851, 10.750535, 10.996452, 10.406416, 9.886891, 9.893788, 8.717857, 9.460459, 10.318561, 9.025084, 10.697048, 9.220000, 10.034703, 10.582268, 10.982542, 9.633132, 11.804596, 8.552506, 9.782989, 8.269786, 10.684005, 8.556229, 10.001265, 10.873050, 9.819898, 10.839027, 9.707648, 10.105907, 9.949774, 9.510519, 10.787063, 8.253046, 9.675076, 10.554044, 10.080417, 10.886992, 11.377604, 9.125705, 12.410167, 8.787085, 8.565598, 9.739762, 9.371276, 10.375179, 8.597003, 11.465136, 10.850936, 10.256778)
tmp_val2 <- c(9.306787, 11.307516, 12.160676, 10.889549, 10.300450, 9.465762, 11.288665, 9.569562, 9.614434, 9.642303, 8.981297, 8.636463, 10.941803, 9.827640, 11.561894, 9.211482, 10.136285, 7.813752, 10.480992, 9.264401, 10.149199, 10.252510, 9.781430, 11.120753, 9.446544, 10.200058, 10.679752, 10.435487, 9.375004, 10.262149, 10.045900, 10.166883, 8.952462, 10.039205, 10.778218, 10.977884, 10.432202, 10.874615, 10.319852, 9.098737, 8.680099, 11.116204, 10.680806, 10.643674, 10.680176, 11.409845, 10.700309, 9.555585, 10.094916, 10.110427, 9.179062, 9.485574, 10.064838, 10.604905, 7.804238, 10.476042, 10.494378, 7.962542, 9.849498, 11.344005, 9.988736, 10.528098, 9.273147, 10.416323, 8.433062, 8.611856, 9.608313, 11.243201, 10.848102, 10.502763, 11.345713, 12.106153, 11.239200, 8.943593, 10.992443, 9.730610, 9.782444, 11.999277, 10.785799, 9.897410, 11.017698, 9.754974, 9.382816, 8.627758, 10.902748, 9.741742, 8.889675, 11.647311, 9.845465, 8.912883, 11.208913, 8.429032, 10.503731, 9.069251, 11.100913, 9.055051, 9.791770, 9.023230, 11.250722, 10.889638, 11.074532, 11.148402, 8.667549, 9.022849, 10.022728, 11.126844, 10.324318, 9.745748, 9.139307, 11.298331, 7.807293, 10.233448, 8.585014, 9.583802, 9.075999, 10.634819, 9.941278, 8.237826, 11.580754, 10.150040, 9.709169, 9.616469, 7.867724, 10.583955, 9.512544, 11.245252, 10.280782, 8.126651, 9.362594, 9.222659, 9.980666, 9.095769, 8.544126, 8.468158, 8.597651, 9.296030, 8.887694, 9.496545, 8.541836, 10.380413, 9.742365, 9.481843, 10.039258, 9.532185, 9.776108, 11.859519, 10.472463, 9.737804, 9.124279, 10.726017, 9.493562, 7.956183, 10.409115, 9.400603, 10.286960, 10.484255, 11.149011, 9.908492, 7.833018, 10.824365, 10.209895, 9.873263, 10.079568, 10.360239, 9.529025, 10.709569, 10.224439, 9.069347, 8.909479, 10.553621, 10.548485, 9.815820, 10.952314, 9.423704, 9.852929, 9.834033, 10.934526, 9.642005, 10.024100, 11.119867, 11.076800, 9.500890, 9.584251, 9.466327, 9.772747, 10.237634, 10.965520, 9.401638, 12.555750, 9.348533, 8.595271, 10.255726, 14.084484, 13.686929, 15.289409, 14.228878, 15.885064, 14.735420)
tmp_val3 <- c(14.411360, 12.742652, 12.513991, 14.385321, 13.456978, 14.329154, 15.080657, 12.834713, 14.591988, 12.884149, 14.442004, 14.005837, 15.223230, 14.831145, 14.866556, 14.526512, 13.439901, 14.262737, 15.516320, 16.712915, 15.236976, 14.900456, 15.132025, 14.551579, 14.235097, 16.055261, 12.207840, 13.239289, 14.973973, 13.435254, 12.808494, 14.371413, 14.148180, 14.807308, 13.738151, 13.843169, 14.542065, 14.434894, 15.016666, 12.559656, 14.877393, 14.499835, 14.522492, 15.192501, 13.080366, 13.648043, 14.232576, 13.911182, 15.206095, 13.019109, 13.873747, 15.278120, 14.918080, 14.190228, 12.892810, 14.149176, 13.541090, 14.533811, 14.252594, 12.658500, 11.898923, 15.650855, 11.978914, 13.796233, 13.777109, 13.800708, 14.072881, 13.296752, 15.313698, 14.074531, 12.931441, 13.617018, 13.023944, 14.400025, 14.520512, 14.666651, 13.914288, 14.549573, 14.030661, 15.794643, 12.389584, 14.249379, 14.737955, 15.137728, 14.150305, 14.335651, 13.179995, 15.830845, 14.322960, 15.438652, 12.309750, 13.386247, 16.141480, 14.562242, 15.302311, 14.343525, 13.838939, 13.716876, 15.272650, 14.849324, 14.144314, 14.591484, 12.398670, 15.374955, 11.892512, 13.374318, 16.032949, 12.730228, 13.687479, 13.237038, 11.565203, 12.501023, 13.370990, 15.750611, 13.043042, 14.492092, 14.811787, 15.346191, 13.477505, 15.968350, 13.432387, 14.074448, 16.131931, 13.296610, 13.372595, 13.523339, 14.013395, 13.472683, 13.846803, 12.351928, 13.294827, 13.397209, 13.335679, 13.846849, 16.288675, 13.994746, 13.431392, 13.255807, 14.002692, 14.946364, 15.439784, 14.803573, 13.388876, 14.667249, 14.486773, 12.631889, 13.905002, 15.332514, 15.931632, 14.012388, 13.762295, 13.595401, 14.529396, 13.041678, 13.252787, 14.367606, 13.751590, 14.787788, 12.782600, 14.443572, 13.622152, 13.413468, 12.332907, 14.740578, 14.088378, 15.643253, 13.749458, 12.025605, 14.736837, 13.327309, 14.267356, 15.076289, 14.218690, 14.446273, 14.949559, 14.632777, 13.361027, 14.513962, 13.896390, 15.017108, 16.469664, 14.610732, 14.406541, 14.073867, 14.661935, 13.591769, 15.042421, 14.568115, 13.793124, 14.403665, 14.113762, 13.250773, 14.615109, 13.447964, 14.156630, 16.110103, 15.564140, 12.461233, 15.123464, 14.771749, 12.948455, 14.197314, 13.444240, 14.219572, 13.372196, 13.714397, 13.726691, 15.874439, 12.537902, 13.153687, 13.174140, 14.488448, 16.716131, 14.640675, 15.830247, 12.635119, 13.331285, 15.167916, 13.540971, 15.891167, 14.880074, 13.024280, 14.414654, 12.285126, 14.263982, 13.868191, 14.207859, 13.678008, 13.059733, 14.690251, 12.440252, 14.162796, 14.095308, 14.709949, 14.453030, 13.361079, 13.793857, 14.081712, 16.178300, 13.909656, 13.666975, 15.416846, 12.670580, 12.799846, 13.511333, 13.407993, 14.835380)
tmp_val4 <- c(12.976824, 14.212054, 14.744901, 13.366618, 13.497829, 14.118244, 14.097567, 14.570320, 15.750099, 12.740684, 12.101717, 14.538162, 16.207392, 14.275388, 13.450429, 13.278878, 12.072511, 11.828691, 14.052406, 14.952943, 14.710529, 13.812375, 13.728951, 14.599026, 14.422452, 13.787463, 15.193843, 14.671115, 12.915126, 14.873965, 13.557251, 13.106522, 14.375077, 11.832420, 13.119148, 14.084569, 15.851941, 14.109399, 15.250919, 13.056173, 12.699970, 14.868558, 14.676192, 13.821108, 13.907066, 13.236936, 14.421735, 15.149177, 14.118141, 13.978043, 12.821003, 14.626043, 13.049613, 14.414876, 13.903175, 15.763494, 14.353706, 13.204484, 12.308968, 14.130513, 12.638311, 13.242591, 14.903555, 12.737772, 12.597035, 14.894000, 13.630604, 15.450248, 13.102321, 13.599745, 14.878281, 13.836940, 13.854894, 13.979052, 14.297079, 13.028968, 14.714078, 13.465488, 14.691662, 15.870258, 14.119122, 14.209284, 14.858950, 14.629495, 13.055205, 15.917658, 13.688632, 14.421340, 13.542917, 14.146830, 14.102894, 14.038985, 15.172495, 13.907774, 13.424017, 15.469321, 12.897190, 15.757472, 13.732474, 13.347816, 14.274985, 14.161663, 14.985244, 12.551531, 11.949327, 13.678261, 14.563523, 12.666979, 14.544652, 12.336321, 14.506581, 14.129931, 13.618266, 13.982368, 13.021618, 14.792348, 15.824932, 15.489194, 12.772979, 13.998547, 14.184919, 14.312848, 13.952443, 15.319870, 13.025480, 14.070808, 13.691343, 14.284067, 13.498489, 12.332955, 15.227115, 13.065817, 14.182305, 14.275005, 13.198193, 14.590461, 13.669542, 14.553285, 13.955487, 15.004996, 15.093431, 12.878360, 13.845262, 14.990967, 14.572977, 15.555476, 15.268771, 13.587714, 14.743777, 14.291496, 13.246333, 12.598201, 13.231606, 13.540469, 14.426586, 13.688556, 14.442573, 14.954538, 13.921595, 12.003486, 17.160572, 14.094224, 15.296731, 14.740435, 14.712037, 13.402379, 13.512222, 13.105954, 15.768772, 13.499300, 13.681601, 17.420138, 15.265717, 12.711743, 14.046230, 13.716103, 13.925226, 14.010263, 15.160868, 14.930765, 16.108654, 13.488955, 14.948638, 13.937744, 14.247066, 13.483477, 12.732504, 13.752022, 13.104279, 14.427676, 14.093514, 14.441670, 14.956576, 13.381326, 13.699386, 13.011757, 15.671108, 13.848778, 13.151486, 14.455463, 14.150988, 14.148907, 13.203109, 12.998502, 13.388559, 13.180142, 14.949925, 13.998141, 15.241981, 13.590375, 13.811913, 12.718706, 12.004796, 14.993120, 13.578540, 15.271183, 15.408452, 14.536968, 11.998053, 14.863462, 15.501437, 12.876994, 13.879076, 12.251913, 14.278606, 13.540261, 15.993972, 13.126617, 14.905674, 15.005513, 15.103431, 12.927382, 14.396834, 13.280524, 14.799659, 13.391005, 13.538120, 14.026451, 14.498228, 11.969916, 14.811337, 15.104438, 15.089462, 14.794311, 12.958128, 14.147342, 15.243942)
input_val <- c(tmp_val1, tmp_val2, tmp_val3, tmp_val4)



test_that('histogram and density, with NA in input', {
  ## warning for default bin number
  # input
  tmp_input <- c(NA, input_val, NA)
  # expected message   
  expected_message <- "`stat_bin()` using `bins = 30`. Pick better value with `binwidth`."
  # expected values
  expected_data <- data.frame(x=input_val)
  
	# generate plot
  result_histoAndDensity  <- plotHistogram(tmp_input, varName='Test variable', density=TRUE)
  # warning message seems to only be thrown when plot is generated to screen
  result_message          <- evaluate_promise(ggplot2::ggplot_build(plotHistogram(tmp_input, varName='Test variable', density=TRUE)))
  
  # Check plot properties
  expect_true(ggplot2::is.ggplot(result_histoAndDensity))
  expect_equal(result_histoAndDensity$labels$x, "Test variable")
  expect_equal(result_histoAndDensity$labels$y, "density")
  expect_equal(result_histoAndDensity$data, expected_data)
  expect_equal(length(result_histoAndDensity), length(ggplot2::ggplot()))
  
  # Check message (warning is caught as result and not warning!?!)
  expect_equal(result_message$messages, expected_message)
})

test_that('histogram without density', {
  # expected values
  expected_data <- data.frame(x=input_val)
  
  # generate plot
  result_histoNoDensity <- plotHistogram(input_val, varName='Test variable 2', density=FALSE)
  
  # Check plot properties
  expect_true(ggplot2::is.ggplot(result_histoNoDensity))
  expect_equal(result_histoNoDensity$labels$x, "Test variable 2")
  expect_equal(result_histoNoDensity$labels$y[1], "count")
  expect_equal(result_histoNoDensity$data, expected_data)
  expect_equal(length(result_histoNoDensity), length(ggplot2::ggplot()))
})

test_that('histogram and density with modified ... (bins)', {
  ## Cannot match the plot itself, so check the warning message is not thrown as a proof 'bins' or 'binwidth' has been set
  
  # expected values
  expected_data <- data.frame(x=input_val)
  
  # generate plot
  result_histoChangeBins  <- plotHistogram(input_val, varName='Test variable 3', density=TRUE, bins=20)
  result_message          <- evaluate_promise(ggplot2::ggplot_build(plotHistogram(input_val, varName='Test variable 3', density=TRUE, bins=20)))
  
  # Check message (no warning means the bins has been successfully set)
  expect_equal(length(result_message$messages), 0)
  
  # Check plot properties
  expect_true(ggplot2::is.ggplot(result_histoChangeBins))
  expect_equal(result_histoChangeBins$labels$x, "Test variable 3")
  expect_equal(result_histoChangeBins$labels$y, "density")
  expect_equal(result_histoChangeBins$data, expected_data)
  expect_equal(length(result_histoChangeBins), length(ggplot2::ggplot()))
})
