context('centroid vs continuum reader stability')

skip_if_not_installed('faahKO',  minimum_version = '1.18.0')
skip_if_not_installed('msdata',  minimum_version = '0.24.1')
library(faahKO)
library(msdata)

# MSnbase does not seem to make a difference in data read and the functions peakPantheR
# employs between centroided and continuum data. To ensure this behavior is constant
# this test reads centroided and continuum data files in both ways and checks that
# once loaded the data is identical.

## Input
# use ko15.CDf file from the pkg faahKO for centroided data
raw_centroided_as_centroided <- MSnbase::readMSData( system.file('cdf/KO/ko15.CDF', package = "faahKO"), centroided=TRUE, mode='onDisk')
raw_centroided_as_continuum <- MSnbase::readMSData( system.file('cdf/KO/ko15.CDF', package = "faahKO"), centroided=FALSE, mode='onDisk')
# use file from the msdata pkg for continuum data
raw_continuum_as_continuum <- MSnbase::readMSData(system.file('sciex/20171016_POOL_POS_1_105-134.mzML', package = "msdata"), centroided=FALSE, mode='onDisk')
raw_continuum_as_centroided <- MSnbase::readMSData(system.file('sciex/20171016_POOL_POS_1_105-134.mzML', package = "msdata"), centroided=TRUE, mode='onDisk')

## Expected
# centroided data
centroided_rt  <- c(3310.459, 3310.459, 3310.459, 3312.024, 3312.024, 3312.024, 3313.589, 3313.589, 3313.589, 3315.154, 3315.154, 3315.154, 3316.719, 3316.719, 3316.719, 3318.284, 3318.284, 3318.284, 3319.849, 3319.849, 3319.849, 3321.414, 3321.414, 3321.414, 3322.979, 3322.979, 3322.979, 3324.544, 3324.544, 3324.544, 3326.109, 3326.109, 3327.673, 3327.673, 3329.238, 3329.238, 3329.238, 3330.803, 3330.803, 3332.368, 3332.368, 3333.933, 3333.933, 3335.498, 3335.498, 3337.063, 3337.063, 3338.628, 3338.628, 3340.193, 3340.193, 3341.758, 3341.758, 3343.323, 3343.323, 3344.888, 3344.888, 3346.453, 3346.453, 3348.018, 3348.018, 3348.018, 3349.583, 3349.583, 3349.583, 3351.148, 3351.148, 3351.148, 3352.713, 3352.713, 3352.713, 3354.278, 3354.278, 3355.843, 3355.843, 3357.408, 3357.408, 3358.973, 3358.973, 3360.538, 3360.538, 3362.102, 3362.102, 3363.667, 3363.667, 3365.232, 3365.232, 3366.797, 3366.797, 3368.362, 3368.362, 3369.927, 3369.927, 3369.927, 3371.492, 3371.492, 3371.492, 3373.057, 3373.057, 3373.057, 3374.622, 3374.622, 3374.622, 3376.187, 3376.187, 3376.187, 3377.752, 3377.752, 3377.752, 3379.317, 3379.317, 3380.882, 3380.882, 3382.447, 3382.447, 3384.012, 3384.012, 3385.577, 3385.577, 3385.577, 3387.142, 3387.142, 3387.142, 3388.707, 3388.707, 3388.707)
centroided_mz  <- c(520.2000122, 521.2999878, 522, 520.2000122, 521, 522.1000366, 520.2000122, 521, 522.1000366, 520.2000122, 521.1000366, 522.2000122, 520.2000122, 521.1000366, 522.2000122, 520.1000366, 521.1000366, 522.2000122, 520.1000366, 521.1000366, 522.2000122, 520.1000366, 521.1000366, 522.2000122, 520.1000366, 521.2000122, 522.2000122, 520.2000122, 521.2999878, 522.2000122, 520.2000122, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 521, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.2000122, 522.2000122, 520.2000122, 522.2000122, 520.2000122, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 520.4000244, 522.2000122, 520, 520.2999878, 522.2000122, 520, 520.2999878, 522.2000122, 520, 520.2999878, 522.2000122, 520, 522.2000122, 520.2999878, 522.2000122, 520.2999878, 522.2000122, 520.2999878, 522.2000122, 520.2999878, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 520.9000244, 522.2000122, 520, 521, 522.2000122, 520.1000366, 521.1000366, 522.2000122, 520.1000366, 521.1000366, 522.2000122, 520.2000122, 521.2000122, 522.2000122, 520.1000366, 521.2000122, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 522.2000122, 520.1000366, 521.2000122, 522.2000122, 520.1000366, 521.2000122, 522.2000122, 520.2000122, 521.2000122, 522.2000122)
centroided_int <- c(1850, 425, 879, 1864, 408, 1112, 1637, 493, 1540, 1466, 590, 2187, 1452, 668, 3534, 1655, 653, 6338, 1828, 665, 11718, 2034, 712, 21744, 2225, 747, 37872, 2485, 814, 62424, 2526, 98408, 2407, 152896, 2186, 925, 225984, 2033, 308672, 1975, 399360, 1997, 504000, 1853, 614656, 1629, 711872, 1420, 784704, 1311, 836608, 1322, 866304, 1360, 882304, 1261, 889280, 1061, 888256, 936, 902, 866816, 958, 920, 827392, 1178, 997, 777728, 1366, 1129, 727040, 1416, 678464, 1541, 629120, 1621, 578048, 1499, 524288, 1300, 471040, 1619, 416320, 2171, 360064, 2632, 302400, 3164, 249152, 3686, 202560, 3914, 1755, 161024, 3679, 1560, 123520, 3255, 1329, 93160, 3230, 1172, 71856, 3475, 1146, 58392, 3573, 1206, 51072, 3427, 48376, 3360, 49168, 3504, 53120, 3751, 62488, 3761, 1061, 78680, 3562, 1336, 102840, 3472, 1338, 134656)
expected_centroided <- list(data.frame(rt=centroided_rt, mz=centroided_mz, int=centroided_int))
# continuum data
continuum_rt  <- c(175.217, 175.217, 175.217, 175.217, 175.217, 175.217, 175.217, 175.217, 175.217, 175.496, 175.496, 175.496, 175.496, 175.496, 175.496, 175.496, 175.496, 175.496, 175.775, 175.775, 175.775, 175.775, 175.775, 175.775, 176.054, 176.054, 176.054, 176.054, 176.054, 176.054, 176.054, 176.054, 176.054, 176.054, 176.333, 176.333, 176.333, 176.333, 176.333, 176.333, 176.333, 176.333, 176.333, 176.612, 176.612, 176.612, 176.612, 176.612, 176.612, 176.612, 176.612, 176.891, 176.891, 176.891, 176.891, 176.891, 176.891, 176.891, 176.891, 176.891, 176.891, 177.171, 177.171, 177.171, 177.171, 177.171, 177.171, 177.171, 177.171, 177.171, 177.171, 177.171, 177.450, 177.450, 177.450, 177.450, 177.450, 177.450, 177.450, 177.450, 177.450, 177.729, 177.729, 177.729, 177.729, 177.729, 177.729, 177.729, 177.729, 178.008, 178.008, 178.008, 178.008, 178.008, 178.008, 178.008, 178.287, 178.287, 178.287, 178.287, 178.287, 178.287, 178.287, 178.566, 178.566, 178.566, 178.566, 178.566, 178.566, 178.566, 178.566, 178.845, 178.845, 178.845, 178.845, 178.845, 178.845, 179.124,
	179.124, 179.124, 179.124, 179.124, 179.124, 179.124, 179.403, 179.403, 179.403, 179.403, 179.403, 179.403, 179.403, 179.403, 179.682, 179.682, 179.682, 179.682, 179.682, 179.682, 179.682, 179.682, 179.682, 179.682, 179.961, 179.961, 179.961, 179.961, 179.961, 179.961, 179.961, 179.961, 179.961, 179.961, 179.961, 179.961, 179.961, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.240, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.519, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 180.798, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.077, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.356, 181.635, 181.635, 181.635, 181.635, 181.635, 181.635, 181.635, 181.635, 181.635, 181.635, 181.635, 181.635, 181.635,
	181.635, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 181.914, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.193, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.472, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 182.751, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.030, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.309, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.588, 183.867, 183.867, 183.867, 183.867, 183.867, 183.867, 183.867, 183.867, 183.867, 183.867, 183.867, 183.867, 183.867, 184.146, 184.146, 184.146, 184.146, 184.146, 184.146, 184.146, 184.146,
	184.146, 184.146, 184.146, 184.146, 184.146, 184.146, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.425, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.704, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 184.983, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.262, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.541, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 185.820, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.099, 186.378, 186.378, 186.378, 186.378, 186.378, 186.378, 186.378, 186.378, 186.378, 186.378, 186.378, 186.378, 186.657, 186.657, 186.657, 186.657, 186.657, 186.657, 186.657, 186.657, 186.657, 186.657, 186.657, 186.936, 186.936, 186.936, 186.936, 186.936, 186.936, 186.936, 186.936)
continuum_mz  <- c(106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0593, 106.0491, 106.0506, 106.0520, 106.0535, 106.0549, 106.0564, 106.0578, 106.0593, 106.0462, 106.0476, 106.0491, 106.0506, 106.0520, 106.0535, 106.0549, 106.0564, 106.0578, 106.0593, 106.0447, 106.0462, 106.0476, 106.0491, 106.0506, 106.0520, 106.0535, 106.0549, 106.0564, 106.0578, 106.0593, 106.0447, 106.0461, 106.0476, 106.0490, 106.0505, 106.0519, 106.0534, 106.0548, 106.0592, 106.0476, 106.0490, 106.0505, 106.0519, 106.0534, 106.0548, 106.0563, 106.0592, 106.0461, 106.0476, 106.0490, 106.0505, 106.0519, 106.0534, 106.0548, 106.0461, 106.0475, 106.0490, 106.0504, 106.0519, 106.0534, 106.0548, 106.0490, 106.0504, 106.0519, 106.0534, 106.0548,
	106.0563, 106.0577, 106.0592, 106.0446, 106.0461, 106.0475, 106.0519, 106.0534, 106.0548, 106.0447, 106.0461, 106.0476, 106.0505, 106.0519, 106.0534, 106.0549, 106.0447, 106.0461, 106.0476, 106.0490, 106.0505, 106.0519, 106.0534, 106.0549, 106.0447, 106.0461, 106.0476, 106.0490, 106.0505, 106.0519, 106.0534, 106.0549, 106.0563, 106.0578, 106.0419, 106.0434, 106.0448, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0434, 106.0448, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0434, 106.0448, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0433, 106.0448, 106.0462, 106.0477, 106.0491, 106.0506, 106.0520, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0433, 106.0448, 106.0462, 106.0477, 106.0491, 106.0506, 106.0520, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0433, 106.0448, 106.0462, 106.0477, 106.0491,
	106.0506, 106.0520, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0418, 106.0433, 106.0447, 106.0462, 106.0476, 106.0491, 106.0505, 106.0520, 106.0534, 106.0549, 106.0563, 106.0578, 106.0592, 106.0404, 106.0418, 106.0433, 106.0447, 106.0462, 106.0476, 106.0491, 106.0505, 106.0520, 106.0534, 106.0549, 106.0563, 106.0578, 106.0592, 106.0404, 106.0418, 106.0433, 106.0447, 106.0462, 106.0476, 106.0491, 106.0505, 106.0520, 106.0534, 106.0549, 106.0563, 106.0578, 106.0592, 106.0404, 106.0418, 106.0433, 106.0447, 106.0462, 106.0476, 106.0491, 106.0505, 106.0520, 106.0534, 106.0549, 106.0563, 106.0578, 106.0592, 106.0404, 106.0418, 106.0433, 106.0447, 106.0462, 106.0476, 106.0491, 106.0505, 106.0520, 106.0534, 106.0549, 106.0563, 106.0578, 106.0592, 106.0404, 106.0418, 106.0433, 106.0447, 106.0462, 106.0476, 106.0491, 106.0505, 106.0520, 106.0534, 106.0549, 106.0563, 106.0578, 106.0592, 106.0405, 106.0419, 106.0434, 106.0448, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0405, 106.0419, 106.0434, 106.0448, 106.0463,
	106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0419, 106.0434, 106.0448, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0433, 106.0448, 106.0462, 106.0477, 106.0491, 106.0506, 106.0520, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0433, 106.0448, 106.0462, 106.0477, 106.0491, 106.0506, 106.0520, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0433, 106.0448, 106.0462, 106.0477, 106.0491, 106.0506, 106.0520, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0405, 106.0419, 106.0434, 106.0448, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0405, 106.0419, 106.0434, 106.0448, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0405, 106.0419, 106.0434, 106.0448, 106.0463, 106.0477, 106.0492, 106.0506, 106.0521, 106.0535, 106.0550, 106.0564, 106.0579, 106.0593, 106.0404, 106.0419, 106.0433, 106.0448,
	106.0462, 106.0477, 106.0491, 106.0506, 106.0520, 106.0535, 106.0549, 106.0564, 106.0578, 106.0593, 106.0404, 106.0419, 106.0433, 106.0448, 106.0462, 106.0477, 106.0491, 106.0506, 106.0520, 106.0535, 106.0549, 106.0564, 106.0578, 106.0593, 106.0433, 106.0448, 106.0462, 106.0477, 106.0491, 106.0506, 106.0520, 106.0535, 106.0549, 106.0564, 106.0578, 106.0593, 106.0445, 106.0460, 106.0474, 106.0489, 106.0504, 106.0518, 106.0533, 106.0547, 106.0562, 106.0576, 106.0591, 106.0460, 106.0474, 106.0489, 106.0504, 106.0518, 106.0533, 106.0547, 106.0562)
continuum_int <- c(0, 81, 162, 81, 0, 81, 0, 0, 81, 0, 121, 61, 182, 61, 61, 61, 0, 61, 0, 49, 0, 148, 148, 0, 0, 105, 35, 70, 35, 35, 35, 0, 0, 70, 0, 99, 66, 99, 33, 33, 132, 0, 0, 0, 81, 41, 0, 122, 0, 41, 0, 0, 38, 76, 0, 0, 76, 0, 0, 76, 0, 0, 68, 103, 137, 137, 0, 0, 34, 0, 34, 34, 0, 45, 178, 45, 89, 134, 134, 0, 0, 0, 196, 147, 49, 0, 49, 0, 0, 0, 45, 89, 89, 0, 45, 0, 0, 48, 48, 0, 0, 96, 0, 0, 342, 86, 0, 86, 0, 86, 0, 0, 203, 0, 0, 203, 0, 0, 407, 0, 0, 407, 203, 0, 0, 203, 0, 406, 0, 406, 203, 0, 0, 406, 813, 1016, 1422, 406, 203, 0, 203, 0, 0, 203, 1016, 1422, 3658, 3861, 3455, 2642, 1829, 610, 203, 203, 203, 0, 203, 203, 2642, 3861, 8535, 15241, 11989, 9957, 4877, 2845, 1422, 813, 610, 0, 203, 407, 4537, 12114, 20459, 22801, 21970, 19189, 11503, 6039, 2491, 1877, 212, 215, 0, 836, 6331, 17371, 28254, 39903, 37100, 22502, 15421, 7623, 5284, 1698, 1698, 432, 215, 1507, 6205, 23466, 40361, 51447, 47899, 32908, 19562, 9074, 5783, 3221, 1082, 0, 431, 1251, 8244, 21983, 34748, 53516, 52937, 39668, 22014, 12518, 4350, 1285, 2398, 630, 645, 1947, 6216, 21336, 43791, 50980, 54316,
    34469, 18510, 9296, 5152, 3902, 1318, 325, 331, 663, 8292, 18781, 32222, 43928, 37416, 30636, 14958, 9259, 5790, 3167, 1003, 678, 0, 798, 3974, 12074, 22410, 28576, 31588, 24399, 12025, 7157, 4847, 2485, 1633, 0, 270, 409, 2178, 8543, 18297, 23541, 16922, 13642, 8021, 6257, 1216, 1217, 687, 123, 121, 361, 1804, 5789, 11837, 9534, 10051, 8473, 4722, 1943, 601, 241, 483, 0, 198, 0, 1252, 3032, 5825, 7972, 8073, 5664, 3991, 2141, 1741, 192, 485, 83, 83, 334, 1336, 1836, 3422, 4674, 4925, 3506, 1252, 835, 501, 250, 250, 69, 69, 138, 689, 2619, 2964, 2826, 2481, 3170, 1309, 620, 138, 69, 138, 0, 164, 327, 982, 3028, 2619, 2291, 1391, 655, 900, 327, 82, 0, 171, 0, 0, 171, 938, 1536, 2389, 1536, 768, 853, 512, 171, 85, 0, 72, 0, 288, 432, 504, 1296, 1799, 1727, 1224, 648, 432, 288, 288, 144, 0, 64, 193, 129, 451, 1868, 1417, 1031, 902, 644, 258, 64, 0, 129, 0, 55, 111, 166, 610, 998, 1498, 1830, 1109, 444, 277, 166, 55, 0, 0, 44, 133, 133, 489, 622, 755, 1155, 800, 755, 355, 89, 44, 89, 36, 0, 0, 218, 508, 798, 1124, 834, 580, 544, 254, 145, 73, 36, 0, 61, 61, 121, 455, 820, 820, 577, 364, 213, 91, 91, 91, 61, 30, 30, 30, 120, 479, 419, 779, 689, 449, 210, 180, 90, 60, 0, 0, 58, 289, 405, 492, 752, 260, 174, 145, 58, 58, 0, 0, 108, 431, 538, 431, 161, 269, 0, 108, 54, 0, 0, 406, 203, 813, 406, 203, 203, 0)
expected_continuum <- list(data.frame(rt=continuum_rt, mz=continuum_mz, int=continuum_int))


test_that('read centroided as centroided', {
  # results (output, warnings and messages)
  result_extractSignalRawData <- evaluate_promise(extractSignalRawData(rawSpec = raw_centroided_as_centroided,
      rt=c(3310., 3390.), mz=c(520., 522.4), msLevel=1L, verbose=TRUE))
  # Check results
  expect_equal(result_extractSignalRawData$result, expected_centroided, tolerance=1e-6)
})

test_that('read centroided as continuum', {
  # results (output, warnings and messages)
  result_extractSignalRawData <- evaluate_promise(extractSignalRawData(rawSpec = raw_centroided_as_continuum,
      rt=c(3310., 3390.), mz=c(520., 522.4), msLevel=1L, verbose=TRUE))
  # Check results
  expect_equal(result_extractSignalRawData$result, expected_centroided, tolerance=1e-6)
})

test_that('read continuum as continuum', {
  # results (output, warnings and messages)
  result_extractSignalRawData <- evaluate_promise(extractSignalRawData(rawSpec = raw_continuum_as_continuum,
      rt=c(175., 187.), mz=c(106.039871, 106.059871), msLevel=1L, verbose=TRUE))
  # Check results
  expect_equal(result_extractSignalRawData$result, expected_continuum, tolerance=1e-6)
})

test_that('read continuum as centroided', {
  # results (output, warnings and messages)
  result_extractSignalRawData <- evaluate_promise(extractSignalRawData(rawSpec = raw_continuum_as_centroided,
      rt=c(175., 187.), mz=c(106.039871, 106.059871), msLevel=1L, verbose=TRUE))
  # Check results
  expect_equal(result_extractSignalRawData$result, expected_continuum, tolerance=1e-6)
})
