% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_peakPantheRAnnotation.R
\docType{methods}
\name{retentionTimeCorrection,peakPantheRAnnotation-method}
\alias{retentionTimeCorrection,peakPantheRAnnotation-method}
\alias{retentionTimeCorrection}
\title{Apply retention time correction methods to adjust the retention time
information in the uROI of peakPantheRAnnotation object}
\usage{
\S4method{retentionTimeCorrection}{peakPantheRAnnotation}(
    annotationObject,
    rtCorrectionReferences = NULL,
    method = "polynomial",
    params = list(polynomialOrder = 2),
    robust = FALSE,
    rtWindowWidth = 15,
    diagnostic = TRUE
)
}
\arguments{
\item{annotationObject}{(peakPantheRAnnotation) object with previous fit
results to adjust retention time values in uROI and FIR
annotationObject, rtCorrectionReferences=NULL,}

\item{rtCorrectionReferences}{(list) of compounds IDs (\code{cpdID})
to be used as retention time references.
All \code{cpdID} entries must be present in the object and previously
annotated. If NULL, use all compounds.}

\item{method}{(str) name of RT correction method to use (currently
\code{polynomial} or \code{constant}}

\item{params}{(list) list of parameters to pass to each correction method.
Currently allowed inputs are \code{polynomialOrder}
for \code{method='polynomial'}}

\item{robust}{(bool) whether to use the RANSAC algorithm to flag and ignore
outliers during retention time correction}

\item{rtWindowWidth}{(numeric) full width in seconds
of the retention time window defined around the corrected retention time
value for each compound}

\item{diagnostic}{(bool) If TRUE returns diagnostic plots (specific to each
correction method)}
}
\value{
(list) containing entries `annotation`, with the new and retention
time corrected peakPantheRAnnotation, and `plot` (if \code{diagnostic=TRUE}).
}
\description{
Performs retention time correction to re-adjust the expected
retention time position of compounds.
Requires an annotated peakPantheRAnnotation object (\code{isAnnotated=TRUE}).
The original \code{rt} value is used as expected and the observed deviation
measured in the \code{rt_dev_sec} field is taken as the deviation to be
corrected.
}
\examples{
if(requireNamespace('faahKO')){
## Initialise a peakPantheRAnnotation object with 3 samples and 2 targeted
## compounds

# Paths to spectra files
library(faahKO)
spectraPaths <- c(system.file('cdf/KO/ko15.CDF', package = 'faahKO'),
                    system.file('cdf/KO/ko16.CDF', package = 'faahKO'))

# targetFeatTable
targetFeatTable <- data.frame(matrix(vector(), 2, 8, dimnames=list(c(),
                    c('cpdID','cpdName','rtMin','rt','rtMax','mzMin','mz',
                    'mzMax'))), stringsAsFactors=FALSE)
targetFeatTable[1,] <- c('ID-1', 'Cpd 1', 3310., 3344.888, 3390., 522.194778,
                        522.2, 522.205222)
targetFeatTable[2,] <- c('ID-2', 'Cpd 2', 3280., 3385.577, 3440., 496.195038,
                        496.2, 496.204962)
targetFeatTable[,c(3:8)] <- vapply(targetFeatTable[,c(3:8)], as.numeric,
                                    FUN.VALUE=numeric(2))

smallAnnotation  <- peakPantheRAnnotation(spectraPaths=spectraPaths,
                                        targetFeatTable=targetFeatTable)
# annotate files serially
annotation_result <- peakPantheR_parallelAnnotation(smallAnnotation,
                                            ncores=0, verbose=TRUE)
data_annotation   <- annotation_result$annotation

# Example with constant correction
rtCorrectionOutput <- retentionTimeCorrection(
                        annotationObject = data_annotation,
                        rtCorrectionReferences=c('ID-1'),
                        method='constant', params=list(),
                        robust=FALSE,
                        rtWindowWidth=15,
                        diagnostic=TRUE)

rtCorrectedAnnotation <- rtCorrectionOutput$annotation

# rtCorrectedAnnotation
# An object of class peakPantheRAnnotation
#  2 compounds in 2 samples.
#  updated ROI exists, with a modified rt (uROI)
#  uses updated ROI (uROI)
#  uses fallback integration regions (FIR)
#  is annotated

rtCorrectionPlot <- rtCorrectionOutput$plot
# rtCorrectedPlot
# A ggplot2 object
#  Scatterplot where x=`r` in the and y=`rt_dev_sec` from data_annotation
#  Points colored depending on whether the reference was used to fit
# the correction model
}
}
