% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methods_peakPantheRAnnotation.R
\docType{methods}
\name{outputAnnotationParamsCSV,peakPantheRAnnotation-method}
\alias{outputAnnotationParamsCSV,peakPantheRAnnotation-method}
\alias{outputAnnotationParamsCSV}
\title{Save annotation parameters as CSV}
\usage{
\S4method{outputAnnotationParamsCSV}{peakPantheRAnnotation}(
    object,
    saveFolder,
    verbose,
    noSave
)
}
\arguments{
\item{object}{(peakPantheRAnnotation) Annotated peakPantheRAnnotation object}

\item{saveFolder}{(str) Path of folder where annotationParameters_summary.csv
will be saved}

\item{verbose}{(bool) If TRUE message progress}

\item{noSave}{(bool) If TRUE the resulting table will be returned without
saving to disk}
}
\value{
None
}
\description{
Save annotation parameters (ROI, uROI and FIR) to disk as a CSV
file for editing
}
\examples{
## Initialise a peakPantheRAnnotation object with 3 samples and 2 targeted
## compounds

# Paths to spectra files
spectraPaths <- c('./path/file1', './path/file2', './path/file3')

# targetFeatTable
targetFeatTable <- data.frame(matrix(vector(), 2, 8, dimnames=list(c(),
                    c('cpdID','cpdName','rtMin','rt','rtMax','mzMin','mz',
                    'mzMax'))), stringsAsFactors=FALSE)
targetFeatTable[1,] <- c('ID-1', 'Cpd 1', 3310., 3344.888, 3390., 522.194778,
                        522.2, 522.205222)
targetFeatTable[2,] <- c('ID-2', 'Cpd 2', 3280., 3385.577, 3440., 496.195038,
                        496.2, 496.204962)
targetFeatTable[,c(3:8)] <- vapply(targetFeatTable[,c(3:8)], as.numeric,
                                    FUN.VALUE=numeric(2))

emptyAnnotation <- peakPantheRAnnotation(spectraPaths=spectraPaths,
                                        targetFeatTable=targetFeatTable)

# temporary file
savePath        <- tempdir()

# statistics of an empty annotation
outputAnnotationParamsCSV(emptyAnnotation, saveFolder=savePath, verbose=TRUE)
}
