## List of packages exported from working environment
## - pinned versions were obtained from
## https://github.com/csoneson/orthos_package_list

if (basilisk.utils::isLinuxAarch64()) {
    .orthos_dependencies <- c(
        "_openmp_mutex==4.5",
        "atk-1.0==2.38.0",
        "brotli-python==1.1.0",
        "bzip2==1.0.8",
        "c-ares==1.34.4",
        "ca-certificates==2024.12.14",
        "cached-property==1.5.2",
        "cached_property==1.5.2",
        "cairo==1.18.2",
        "certifi==2024.12.14",
        "cffi==1.17.1",
        "charset-normalizer==3.4.1",
        "font-ttf-dejavu-sans-mono==2.37",
        "font-ttf-inconsolata==3.000",
        "font-ttf-source-code-pro==2.038",
        "font-ttf-ubuntu==0.83",
        "fontconfig==2.15.0",
        "fonts-conda-ecosystem==1",
        "fonts-conda-forge==1",
        "freetype==2.12.1",
        "fribidi==1.0.10",
        "gdk-pixbuf==2.42.12",
        "graphite2==1.3.13",
        "graphviz==12.0.0",
        "gtk2==2.24.33",
        "gts==0.7.6",
        "h2==4.1.0",
        "h5py==3.11.0",
        "harfbuzz==10.2.0",
        "hdf5==1.14.3",
        "hpack==4.1.0",
        "hyperframe==6.1.0",
        "icu==75.1",
        "idna==3.10",
        "keras==2.15.0",
        "keyutils==1.6.1",
        "krb5==1.21.3",
        "lcms2==2.16",
        "ld_impl_linux-aarch64==2.43",
        "lerc==4.0.0",
        "libaec==1.1.3",
        "libblas==3.9.0",
        "libcblas==3.9.0",
        "libcurl==8.11.1",
        "libdeflate==1.23",
        "libedit==3.1.20240808",
        "libev==4.33",
        "libexpat==2.6.4",
        "libffi==3.4.2",
        "libgcc==14.2.0",
        "libgcc-ng==14.2.0",
        "libgd==2.3.3",
        "libgfortran==14.2.0",
        "libgfortran-ng==14.2.0",
        "libgfortran5==14.2.0",
        "libglib==2.82.2",
        "libgomp==14.2.0",
        "libiconv==1.17",
        "libjpeg-turbo==3.0.0",
        "liblapack==3.9.0",
        "liblzma==5.6.3",
        "liblzma-devel==5.6.3",
        "libnghttp2==1.64.0",
        "libnsl==2.0.1",
        "libopenblas==0.3.28",
        "libpng==1.6.46",
        "librsvg==2.58.4",
        "libsqlite==3.48.0",
        "libssh2==1.11.1",
        "libstdcxx==14.2.0",
        "libstdcxx-ng==14.2.0",
        "libtiff==4.7.0",
        "libuuid==2.38.1",
        "libwebp-base==1.5.0",
        "libxcb==1.17.0",
        "libxcrypt==4.4.36",
        "libxml2==2.13.5",
        "libzlib==1.3.1",
        "ncurses==6.5",
        "numpy==1.26.4",
        "openjpeg==2.5.3",
        "openssl==3.4.0",
        "pandas==2.2.2",
        "pango==1.56.1",
        "pcre2==10.44",
        "pillow==10.4.0",
        "pip==24.3.1",
        "pixman==0.44.2",
        "pthread-stubs==0.4",
        "pycparser==2.22",
        "pydot==3.0.1",
        "pyparsing==3.2.1",
        "pysocks==1.7.1",
        "python==3.10.14",
        "python-dateutil==2.9.0.post0",
        "python-tzdata==2025.1",
        "python_abi==3.10",
        "pytz==2024.2",
        "readline==8.2",
        "requests==2.32.3",
        "scipy==1.14.0",
        "setuptools==75.8.0",
        "six==1.17.0",
        "tk==8.6.13",
        "tzdata==2025a",
        "urllib3==2.3.0",
        "wheel==0.45.1",
        "xorg-libice==1.1.2",
        "xorg-libsm==1.2.5",
        "xorg-libx11==1.8.10",
        "xorg-libxau==1.0.12",
        "xorg-libxdmcp==1.1.5",
        "xorg-libxext==1.3.6",
        "xorg-libxrender==0.9.12",
        "xz==5.6.3",
        "xz-gpl-tools==5.6.3",
        "xz-tools==5.6.3",
        "zstandard==0.23.0",
        "zstd==1.5.6"
    )
    .pip_dependencies <- c(
        "absl-py==2.1.0",
        "astunparse==1.6.3",
        "cachetools==5.5.1",
        "flatbuffers==25.1.24",
        "gast==0.6.0",
        "google-auth==2.38.0",
        "google-auth-oauthlib==1.2.1",
        "google-pasta==0.2.0",
        "grpcio==1.70.0",
        "libclang==18.1.1",
        "markdown==3.7",
        "markupsafe==3.0.2",
        "ml-dtypes==0.2.0",
        "oauthlib==3.2.2",
        "opt-einsum==3.4.0",
        "packaging==24.2",
        "protobuf==4.25.6",
        "pyasn1==0.6.1",
        "pyasn1-modules==0.4.1",
        "requests-oauthlib==2.0.0",
        "rsa==4.9",
        "tensorboard==2.15.2",
        "tensorboard-data-server==0.7.2",
        "tensorflow==2.15.0",
        "tensorflow-cpu-aws==2.15.0",
        "tensorflow-estimator==2.15.0",
        "tensorflow-io-gcs-filesystem==0.37.1",
        "termcolor==2.5.0",
        "typing-extensions==4.12.2",
        "werkzeug==3.1.3",
        "wrapt==1.14.1"
    )
} else if (basilisk.utils::isLinux()) {
    .orthos_dependencies <- c(
        "_libgcc_mutex==0.1",
        "_openmp_mutex==4.5",
        "absl-py==2.2.0",
        "aiohappyeyeballs==2.6.1",
        "aiohttp==3.11.16",
        "aiosignal==1.3.2",
        "astunparse==1.6.3",
        "atk-1.0==2.38.0",
        "attrs==25.3.0",
        "blinker==1.9.0",
        "brotli-python==1.1.0",
        "bzip2==1.0.8",
        "c-ares==1.34.5",
        "ca-certificates==2025.1.31",
        "cached-property==1.5.2",
        "cached_property==1.5.2",
        "cachetools==5.5.2",
        "cairo==1.18.0",
        "certifi==2025.1.31",
        "cffi==1.17.1",
        "charset-normalizer==3.4.1",
        "click==8.1.8",
        "cryptography==44.0.2",
        "expat==2.7.0",
        "flatbuffers==23.5.26",
        "font-ttf-dejavu-sans-mono==2.37",
        "font-ttf-inconsolata==3.000",
        "font-ttf-source-code-pro==2.038",
        "font-ttf-ubuntu==0.83",
        "fontconfig==2.15.0",
        "fonts-conda-ecosystem==1",
        "fonts-conda-forge==1",
        "freetype==2.13.3",
        "fribidi==1.0.10",
        "frozenlist==1.5.0",
        "gast==0.6.0",
        "gdk-pixbuf==2.42.12",
        "giflib==5.2.2",
        "google-auth==2.38.0",
        "google-auth-oauthlib==1.2.1",
        "google-pasta==0.2.0",
        "graphite2==1.3.13",
        "graphviz==12.0.0",
        "grpcio==1.59.3",
        "gtk2==2.24.33",
        "gts==0.7.6",
        "h2==4.2.0",
        "h5py==3.13.0",
        "harfbuzz==9.0.0",
        "hdf5==1.14.3",
        "hpack==4.1.0",
        "hyperframe==6.1.0",
        "icu==73.2",
        "idna==3.10",
        "importlib-metadata==8.6.1",
        "keras==2.15.0",
        "keyutils==1.6.1",
        "krb5==1.21.3",
        "lcms2==2.17",
        "ld_impl_linux-64==2.43",
        "lerc==4.0.0",
        "libabseil==20230802.1",
        "libaec==1.1.3",
        "libblas==3.9.0",
        "libcblas==3.9.0",
        "libcurl==8.13.0",
        "libdeflate==1.23",
        "libedit==3.1.20250104",
        "libev==4.33",
        "libexpat==2.7.0",
        "libffi==3.4.6",
        "libgcc==14.2.0",
        "libgcc-ng==14.2.0",
        "libgd==2.3.3",
        "libgfortran==14.2.0",
        "libgfortran5==14.2.0",
        "libglib==2.84.1",
        "libgomp==14.2.0",
        "libgrpc==1.59.3",
        "libiconv==1.18",
        "libjpeg-turbo==3.0.0",
        "liblapack==3.9.0",
        "liblzma==5.8.1",
        "liblzma-devel==5.8.1",
        "libnghttp2==1.64.0",
        "libnsl==2.0.1",
        "libopenblas==0.3.29",
        "libpng==1.6.47",
        "libprotobuf==4.24.4",
        "libre2-11==2023.09.01",
        "librsvg==2.58.4",
        "libsqlite==3.49.1",
        "libssh2==1.11.1",
        "libstdcxx==14.2.0",
        "libstdcxx-ng==14.2.0",
        "libtiff==4.7.0",
        "libuuid==2.38.1",
        "libwebp==1.5.0",
        "libwebp-base==1.5.0",
        "libxcb==1.17.0",
        "libxcrypt==4.4.36",
        "libxml2==2.12.7",
        "libzlib==1.3.1",
        "markdown==3.6",
        "markupsafe==3.0.2",
        "ml_dtypes==0.2.0",
        "multidict==6.3.2",
        "ncurses==6.5",
        "numpy==1.26.4",
        "oauthlib==3.2.2",
        "openjpeg==2.5.3",
        "openssl==3.5.0",
        "opt_einsum==3.4.0",
        "packaging==24.2",
        "pandas==2.2.3",
        "pango==1.54.0",
        "pcre2==10.44",
        "pillow==11.1.0",
        "pip==25.0.1",
        "pixman==0.44.2",
        "propcache==0.2.1",
        "protobuf==4.24.4",
        "pthread-stubs==0.4",
        "pyasn1==0.6.1",
        "pyasn1-modules==0.4.2",
        "pycparser==2.22",
        "pydot==3.0.4",
        "pyjwt==2.10.1",
        "pyopenssl==25.0.0",
        "pyparsing==3.2.3",
        "pysocks==1.7.1",
        "python==3.11.11",
        "python-dateutil==2.9.0.post0",
        "python-flatbuffers==25.2.10",
        "python-tzdata==2025.2",
        "python_abi==3.11",
        "pytz==2024.1",
        "pyu2f==0.1.5",
        "re2==2023.09.01",
        "readline==8.2",
        "requests==2.32.3",
        "requests-oauthlib==2.0.0",
        "rsa==4.9",
        "scipy==1.15.2",
        "setuptools==78.1.0",
        "six==1.17.0",
        "snappy==1.1.10",
        "tensorboard==2.15.2",
        "tensorboard-data-server==0.7.0",
        "tensorflow==2.15.0",
        "tensorflow-base==2.15.0",
        "tensorflow-estimator==2.15.0",
        "termcolor==3.0.1",
        "tk==8.6.13",
        "typing-extensions==4.13.1",
        "typing_extensions==4.13.1",
        "tzdata==2025b",
        "urllib3==2.3.0",
        "werkzeug==3.1.3",
        "wheel==0.45.1",
        "wrapt==1.14.1",
        "xorg-libice==1.1.2",
        "xorg-libsm==1.2.6",
        "xorg-libx11==1.8.12",
        "xorg-libxau==1.0.12",
        "xorg-libxdmcp==1.1.5",
        "xorg-libxext==1.3.6",
        "xorg-libxrender==0.9.12",
        "xz==5.8.1",
        "xz-gpl-tools==5.8.1",
        "xz-tools==5.8.1",
        "yarl==1.18.3",
        "zipp==3.21.0",
        "zlib==1.3.1",
        "zstandard==0.23.0",
        "zstd==1.5.7"
    )
    .pip_dependencies <- character(0)
} else if (basilisk.utils::isMacOSXArm()) {
    .orthos_dependencies <- c(
        "absl-py==2.2.0",
        "aiohappyeyeballs==2.6.1",
        "aiohttp==3.11.16",
        "aiosignal==1.3.2",
        "astunparse==1.6.3",
        "atk-1.0==2.38.0",
        "attrs==25.3.0",
        "blinker==1.9.0",
        "brotli-python==1.1.0",
        "bzip2==1.0.8",
        "c-ares==1.34.5",
        "ca-certificates==2025.1.31",
        "cached-property==1.5.2",
        "cached_property==1.5.2",
        "cachetools==5.5.2",
        "cairo==1.18.0",
        "certifi==2025.1.31",
        "cffi==1.17.1",
        "charset-normalizer==3.4.1",
        "click==8.1.8",
        "cryptography==44.0.2",
        "expat==2.7.0",
        "flatbuffers==23.5.26",
        "font-ttf-dejavu-sans-mono==2.37",
        "font-ttf-inconsolata==3.000",
        "font-ttf-source-code-pro==2.038",
        "font-ttf-ubuntu==0.83",
        "fontconfig==2.15.0",
        "fonts-conda-ecosystem==1",
        "fonts-conda-forge==1",
        "freetype==2.13.3",
        "fribidi==1.0.10",
        "frozenlist==1.5.0",
        "gast==0.6.0",
        "gdk-pixbuf==2.42.12",
        "giflib==5.2.2",
        "google-auth==2.38.0",
        "google-auth-oauthlib==1.2.1",
        "google-pasta==0.2.0",
        "graphite2==1.3.13",
        "graphviz==12.0.0",
        "grpcio==1.59.3",
        "gtk2==2.24.33",
        "gts==0.7.6",
        "h2==4.2.0",
        "h5py==3.13.0",
        "harfbuzz==9.0.0",
        "hdf5==1.14.3",
        "hpack==4.1.0",
        "hyperframe==6.1.0",
        "icu==73.2",
        "idna==3.10",
        "importlib-metadata==8.6.1",
        "keras==2.15.0",
        "krb5==1.21.3",
        "lcms2==2.17",
        "lerc==4.0.0",
        "libabseil==20230802.1",
        "libaec==1.1.3",
        "libblas==3.9.0",
        "libcblas==3.9.0",
        "libcurl==8.13.0",
        "libcxx==20.1.2",
        "libdeflate==1.23",
        "libedit==3.1.20250104",
        "libev==4.33",
        "libexpat==2.7.0",
        "libffi==3.4.6",
        "libgd==2.3.3",
        "libgfortran==14.2.0",
        "libgfortran5==14.2.0",
        "libglib==2.84.0",
        "libgrpc==1.59.3",
        "libiconv==1.18",
        "libintl==0.23.1",
        "libjpeg-turbo==3.0.0",
        "liblapack==3.9.0",
        "liblzma==5.8.1",
        "liblzma-devel==5.8.1",
        "libnghttp2==1.64.0",
        "libopenblas==0.3.29",
        "libpng==1.6.47",
        "libprotobuf==4.24.4",
        "libre2-11==2023.09.01",
        "librsvg==2.58.4",
        "libsqlite==3.49.1",
        "libssh2==1.11.1",
        "libtiff==4.7.0",
        "libwebp==1.5.0",
        "libwebp-base==1.5.0",
        "libxcb==1.17.0",
        "libxml2==2.12.7",
        "libzlib==1.3.1",
        "llvm-openmp==20.1.2",
        "markdown==3.6",
        "markupsafe==3.0.2",
        "ml_dtypes==0.2.0",
        "multidict==6.3.2",
        "ncurses==6.5",
        "numpy==1.26.4",
        "oauthlib==3.2.2",
        "openjpeg==2.5.3",
        "openssl==3.5.0",
        "opt_einsum==3.4.0",
        "packaging==24.2",
        "pandas==2.2.3",
        "pango==1.54.0",
        "pcre2==10.44",
        "pillow==11.1.0",
        "pip==25.0.1",
        "pixman==0.44.2",
        "propcache==0.2.1",
        "protobuf==4.24.4",
        "pthread-stubs==0.4",
        "pyasn1==0.6.1",
        "pyasn1-modules==0.4.2",
        "pycparser==2.22",
        "pydot==3.0.4",
        "pyjwt==2.10.1",
        "pyopenssl==25.0.0",
        "pyparsing==3.2.3",
        "pysocks==1.7.1",
        "python==3.11.11",
        "python-dateutil==2.9.0.post0",
        "python-flatbuffers==25.2.10",
        "python-tzdata==2025.2",
        "python_abi==3.11",
        "pytz==2024.1",
        "pyu2f==0.1.5",
        "re2==2023.09.01",
        "readline==8.2",
        "requests==2.32.3",
        "requests-oauthlib==2.0.0",
        "rsa==4.9",
        "scipy==1.15.2",
        "setuptools==78.1.0",
        "six==1.17.0",
        "snappy==1.1.10",
        "tensorboard==2.15.2",
        "tensorboard-data-server==0.7.0",
        "tensorflow==2.15.0",
        "tensorflow-base==2.15.0",
        "tensorflow-estimator==2.15.0",
        "termcolor==3.0.1",
        "tk==8.6.13",
        "typing-extensions==4.13.1",
        "typing_extensions==4.13.1",
        "tzdata==2025b",
        "urllib3==2.3.0",
        "werkzeug==3.1.3",
        "wheel==0.45.1",
        "wrapt==1.14.1",
        "xorg-libxau==1.0.12",
        "xorg-libxdmcp==1.1.5",
        "xz==5.8.1",
        "xz-gpl-tools==5.8.1",
        "xz-tools==5.8.1",
        "yarl==1.18.3",
        "zipp==3.21.0",
        "zlib==1.3.1",
        "zstandard==0.23.0",
        "zstd==1.5.7"
    )
    .pip_dependencies <- character(0)
} else if (basilisk.utils::isMacOSX()) {
    .orthos_dependencies <- c(
        "absl-py==2.2.0",
        "aiohappyeyeballs==2.6.1",
        "aiohttp==3.11.16",
        "aiosignal==1.3.2",
        "astunparse==1.6.3",
        "atk-1.0==2.38.0",
        "attrs==25.3.0",
        "blinker==1.9.0",
        "brotli-python==1.1.0",
        "bzip2==1.0.8",
        "c-ares==1.34.5",
        "ca-certificates==2025.1.31",
        "cached-property==1.5.2",
        "cached_property==1.5.2",
        "cachetools==5.5.2",
        "cairo==1.18.0",
        "certifi==2025.1.31",
        "cffi==1.17.1",
        "charset-normalizer==3.4.1",
        "click==8.1.8",
        "cryptography==44.0.2",
        "expat==2.7.0",
        "flatbuffers==23.5.26",
        "font-ttf-dejavu-sans-mono==2.37",
        "font-ttf-inconsolata==3.000",
        "font-ttf-source-code-pro==2.038",
        "font-ttf-ubuntu==0.83",
        "fontconfig==2.15.0",
        "fonts-conda-ecosystem==1",
        "fonts-conda-forge==1",
        "freetype==2.13.3",
        "fribidi==1.0.10",
        "frozenlist==1.5.0",
        "gast==0.6.0",
        "gdk-pixbuf==2.42.12",
        "giflib==5.2.2",
        "google-auth==2.38.0",
        "google-auth-oauthlib==1.2.1",
        "google-pasta==0.2.0",
        "graphite2==1.3.13",
        "graphviz==12.0.0",
        "grpcio==1.59.3",
        "gtk2==2.24.33",
        "gts==0.7.6",
        "h2==4.2.0",
        "h5py==3.13.0",
        "harfbuzz==9.0.0",
        "hdf5==1.14.3",
        "hpack==4.1.0",
        "hyperframe==6.1.0",
        "icu==73.2",
        "idna==3.10",
        "importlib-metadata==8.6.1",
        "keras==2.15.0",
        "krb5==1.21.3",
        "lcms2==2.17",
        "lerc==4.0.0",
        "libabseil==20230802.1",
        "libaec==1.1.3",
        "libblas==3.9.0",
        "libcblas==3.9.0",
        "libcurl==8.13.0",
        "libcxx==20.1.2",
        "libdeflate==1.23",
        "libedit==3.1.20250104",
        "libev==4.33",
        "libexpat==2.7.0",
        "libffi==3.4.6",
        "libgd==2.3.3",
        "libgfortran==14.2.0",
        "libgfortran5==14.2.0",
        "libglib==2.84.0",
        "libgrpc==1.59.3",
        "libiconv==1.18",
        "libintl==0.23.1",
        "libjpeg-turbo==3.0.0",
        "liblapack==3.9.0",
        "liblzma==5.8.1",
        "liblzma-devel==5.8.1",
        "libnghttp2==1.64.0",
        "libopenblas==0.3.29",
        "libpng==1.6.47",
        "libprotobuf==4.24.4",
        "libre2-11==2023.09.01",
        "librsvg==2.58.4",
        "libsqlite==3.49.1",
        "libssh2==1.11.1",
        "libtiff==4.7.0",
        "libwebp==1.5.0",
        "libwebp-base==1.5.0",
        "libxcb==1.17.0",
        "libxml2==2.12.7",
        "libzlib==1.3.1",
        "llvm-openmp==20.1.2",
        "markdown==3.6",
        "markupsafe==3.0.2",
        "ml_dtypes==0.2.0",
        "multidict==6.3.2",
        "ncurses==6.5",
        "numpy==1.26.4",
        "oauthlib==3.2.2",
        "openjpeg==2.5.3",
        "openssl==3.5.0",
        "opt_einsum==3.4.0",
        "packaging==24.2",
        "pandas==2.2.3",
        "pango==1.54.0",
        "pcre2==10.44",
        "pillow==11.1.0",
        "pip==25.0.1",
        "pixman==0.44.2",
        "propcache==0.2.1",
        "protobuf==4.24.4",
        "pthread-stubs==0.4",
        "pyasn1==0.6.1",
        "pyasn1-modules==0.4.2",
        "pycparser==2.22",
        "pydot==3.0.4",
        "pyjwt==2.10.1",
        "pyopenssl==25.0.0",
        "pyparsing==3.2.3",
        "pysocks==1.7.1",
        "python==3.11.11",
        "python-dateutil==2.9.0.post0",
        "python-flatbuffers==25.2.10",
        "python-tzdata==2025.2",
        "python_abi==3.11",
        "pytz==2024.1",
        "pyu2f==0.1.5",
        "re2==2023.09.01",
        "readline==8.2",
        "requests==2.32.3",
        "requests-oauthlib==2.0.0",
        "rsa==4.9",
        "scipy==1.15.2",
        "setuptools==78.1.0",
        "six==1.17.0",
        "snappy==1.1.10",
        "tensorboard==2.15.2",
        "tensorboard-data-server==0.7.0",
        "tensorflow==2.15.0",
        "tensorflow-base==2.15.0",
        "tensorflow-estimator==2.15.0",
        "termcolor==3.0.1",
        "tk==8.6.13",
        "typing-extensions==4.13.1",
        "typing_extensions==4.13.1",
        "tzdata==2025b",
        "urllib3==2.3.0",
        "werkzeug==3.1.3",
        "wheel==0.45.1",
        "wrapt==1.14.1",
        "xorg-libxau==1.0.12",
        "xorg-libxdmcp==1.1.5",
        "xz==5.8.1",
        "xz-gpl-tools==5.8.1",
        "xz-tools==5.8.1",
        "yarl==1.18.3",
        "zipp==3.21.0",
        "zlib==1.3.1",
        "zstandard==0.23.0",
        "zstd==1.5.7")
    .pip_dependencies <- character(0)
} else if (basilisk.utils::isWindows()) {
    .orthos_dependencies <- c(
        "brotli-python==1.1.0",
        "bzip2==1.0.8",
        "ca-certificates==2024.7.4",
        "cached-property==1.5.2",
        "cached_property==1.5.2",
        "cairo==1.16.0",
        "certifi==2024.7.4",
        "charset-normalizer==2.1.1",
        "expat==2.6.2",
        "font-ttf-dejavu-sans-mono==2.37",
        "font-ttf-inconsolata==3.000",
        "font-ttf-source-code-pro==2.038",
        "font-ttf-ubuntu==0.83",
        "fontconfig==2.14.2",
        "fonts-conda-ecosystem==1",
        "fonts-conda-forge==1",
        "freetype==2.12.1",
        "fribidi==1.0.10",
        "getopt-win32==0.1",
        "graphite2==1.3.13",
        "graphviz==8.1.0",
        "gts==0.7.6",
        "h5py==3.7.0",
        "harfbuzz==7.3.0",
        "hdf5==1.12.2",
        "icu==72.1",
        "idna==3.7",
        "intel-openmp==2024.2.1",
        "jpeg==9e",
        "krb5==1.21.3",
        "lcms2==2.15",
        "lerc==4.0.0",
        "libaec==1.1.3",
        "libblas==3.9.0",
        "libcblas==3.9.0",
        "libcurl==8.9.1",
        "libdeflate==1.17",
        "libexpat==2.6.2",
        "libffi==3.4.2",
        "libgd==2.3.3",
        "libglib==2.80.3",
        "libhwloc==2.11.1",
        "libiconv==1.17",
        "libintl==0.22.5",
        "liblapack==3.9.0",
        "libpng==1.6.43",
        "libsqlite==3.46.0",
        "libssh2==1.11.0",
        "libtiff==4.5.0",
        "libwebp==1.4.0",
        "libwebp-base==1.4.0",
        "libxcb==1.13",
        "libxml2==2.12.7",
        "libzlib==1.3.1",
        "m2w64-gcc-libgfortran==5.3.0",
        "m2w64-gcc-libs==5.3.0",
        "m2w64-gcc-libs-core==5.3.0",
        "m2w64-gmp==6.1.0",
        "m2w64-libwinpthread-git==5.0.0.4634.697f757",
        "mkl==2024.1.0",
        "msys2-conda-epoch==20160418",
        "numpy==1.22.4",
        "openjpeg==2.5.0",
        "openssl==3.3.1",
        "pandas==1.3.5",
        "pango==1.50.14",
        "pcre2==10.44",
        "pillow==9.2.0",
        "pip==24.2",
        "pixman==0.43.4",
        "pthread-stubs==0.4",
        "pthreads-win32==2.9.1",
        "pydot==1.4.2",
        "pyparsing==3.1.2",
        "pysocks==1.7.1",
        "python==3.8.19",
        "python-dateutil==2.9.0",
        "python_abi==3.8",
        "pytz==2024.1",
        "requests==2.28.1",
        "scipy==1.7.3",
        "setuptools==59.8.0",
        "six==1.16.0",
        "tbb==2021.12.0",
        "tk==8.6.13",
        "ucrt==10.0.22621.0",
        "urllib3==1.26.19",
        "vc==14.3",
        "vc14_runtime==14.40.33810",
        "vs2015_runtime==14.40.33810",
        "wheel==0.44.0",
        "win_inet_pton==1.1.0",
        "xorg-kbproto==1.0.7",
        "xorg-libice==1.0.10",
        "xorg-libsm==1.2.3",
        "xorg-libx11==1.8.4",
        "xorg-libxau==1.0.11",
        "xorg-libxdmcp==1.1.3",
        "xorg-libxext==1.3.4",
        "xorg-libxpm==3.5.16",
        "xorg-libxt==1.3.0",
        "xorg-xextproto==7.3.0",
        "xorg-xproto==7.0.31",
        "xz==5.2.6",
        "zlib==1.3.1",
        "zstd==1.5.6"
    )
    .pip_dependencies <- c(
        "absl-py==2.1.0",
        "astunparse==1.6.3",
        "cachetools==5.5.0",
        "flatbuffers==24.3.25",
        "gast==0.4.0",
        "google-auth==2.34.0",
        "google-auth-oauthlib==0.4.6",
        "google-pasta==0.2.0",
        "grpcio==1.65.5",
        "importlib-metadata==8.3.0",
        "keras==2.10.0",
        "keras-preprocessing==1.1.2",
        "libclang==18.1.1",
        "markdown==3.7",
        "markupsafe==2.1.5",
        "oauthlib==3.2.2",
        "opt-einsum==3.3.0",
        "packaging==24.1",
        "protobuf==3.19.6",
        "pyasn1==0.6.0",
        "pyasn1-modules==0.4.0",
        "requests-oauthlib==2.0.0",
        "rsa==4.9",
        "tensorboard==2.10.1",
        "tensorboard-data-server==0.6.1",
        "tensorboard-plugin-wit==1.8.1",
        "tensorflow==2.10.0",
        "tensorflow-estimator==2.10.0",
        "tensorflow-io-gcs-filesystem==0.31.0",
        "termcolor==2.4.0",
        "typing-extensions==4.12.2",
        "werkzeug==3.0.3",
        "wrapt==1.16.0",
        "zipp==3.20.0"
    )
}

#' @author Charlotte Soneson
#'
#' @importFrom basilisk BasiliskEnvironment
orthosenv <- basilisk::BasiliskEnvironment(
    envname = "orthos", pkgname = "orthos",
    packages = .orthos_dependencies,
    pip = .pip_dependencies,
    channels = "conda-forge"
)
