% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prepare_tree.R
\name{prepare_tree}
\alias{prepare_tree}
\title{Prepare a phylogenetic tree}
\source{
\href{https://doi.org/10.1093/molbev/msac174}{
TimeTree 5: An Expanded Resource for Species Divergence Times}
}
\usage{
prepare_tree(
  tree_source = "timetree",
  species = NULL,
  output_format = "scientific_name_formatted",
  run_map_species = c(TRUE, TRUE),
  method = c("homologene", "gprofiler", "babelgene"),
  force_ultrametric = TRUE,
  age_max = NULL,
  show_plot = TRUE,
  save_dir = tools::R_user_dir("orthogene", which = "cache"),
  verbose = TRUE,
  ...
)
}
\arguments{
\item{tree_source}{Can be one of the following:
\itemize{
\item{"timetree2022":\cr}{Import and prune the
\href{https://doi.org/10.1093/molbev/msac174}{
TimeTree >147k species} phylogenetic tree. Can also simply type "timetree".}
\item{"timetree2015":\cr}{Import and prune the
\href{http://www.timetree.org/public/data/TimetreeOfLife2015.nwk}{
TimeTree >50k species} phylogenetic tree.}
\item{"OmaDB":\cr}{Construct a tree from \href{omabrowser.org}{OMA} 
(Orthologous Matrix browser) via the \link[OmaDB]{getTaxonomy} function.
\emph{NOTE: } Does not contain branch lengths,
 and therefore may have limited utility.}
\item{"UCSC":\cr}{Import and prune the 
\href{https://hgdownload.soe.ucsc.edu/goldenPath/hg38/multiz100way/}{
UCSC 100-way alignment} phylogenetic tree (hg38 version).}
\item{"<path>":\cr}{Read a tree from a newick text file 
from a local or remote URL using \link[ape]{read.tree}.}  
}}

\item{species}{Species names to subset the tree by 
(after \code{standardise_species} step).}

\item{output_format}{Which column to return.}

\item{run_map_species}{Whether to first standardise species names with 
\link[orthogene]{map_species}.}

\item{method}{R package to use for gene mapping:
\itemize{
\item{\code{"gprofiler"} : Slower but more species and genes.}
\item{\code{"homologene"} : Faster but fewer species and genes.}
\item{\code{"babelgene"} : Faster but fewer species and genes.
Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{force_ultrametric}{Whether to force the tree to be ultrametric 
(i.e. make all tips the same date) using \link[phytools]{force.ultrametric}.}

\item{age_max}{Rescale the edges of the tree into units of 
millions of years (MY) instead than evolutionary rates (e.g. dN/dS ratios).
Only used if \code{age_max}, the max number , is numeric. Times are computed using
\link[ape]{makeChronosCalib} and \link[ape]{chronos}.}

\item{show_plot}{Show a basic plot of the resulting tree.}

\item{save_dir}{Directory to cache full tree in. 
Set to \code{NULL} to avoid using cache.}

\item{verbose}{Print messages.}

\item{...}{Additional arguments passed to \link[ape]{makeChronosCalib}.}
}
\value{
A filtered tree of class "phylo" (with standardised species names).
}
\description{
Import a phylogenetic tree  and then conduct 
a series of optional standardisation steps.
Optionally, if \code{output_format} is not \code{NULL}, species names from 
 both the tree and the \code{species} argument will first be standardised
 using \link[orthogene]{map_species}.
}
\examples{
species <- c("human","chimp","mouse")
tr <- orthogene::prepare_tree(species = species)
}
