% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_orthologs.R
\name{map_orthologs}
\alias{map_orthologs}
\title{Map orthologs}
\usage{
map_orthologs(
  genes,
  standardise_genes = FALSE,
  input_species,
  output_species = "human",
  method = c("gprofiler", "homologene", "babelgene"),
  mthreshold = Inf,
  gene_map = NULL,
  input_col = "input_gene",
  output_col = "ortholog_gene",
  verbose = TRUE,
  ...
)
}
\arguments{
\item{genes}{can be a mixture of any format
(HGNC, Ensembl, RefSeq, UniProt, etc.)
 and will be automatically converted to
  standardised HGNC symbol format.}

\item{standardise_genes}{If \code{TRUE} AND
\code{gene_output="columns"}, a new column "input_gene_standard"
will be added to \code{gene_df} containing standardised HGNC symbols
identified by \link[gprofiler2]{gorth}.}

\item{input_species}{Name of the input species (e.g., "mouse","fly").
Use \link[orthogene]{map_species} to return a full list
of available species.}

\item{output_species}{Name of the output species (e.g. "human","chicken").
Use \link[orthogene]{map_species} to return a full list
 of available species.}

\item{method}{R package to use for gene mapping:
\itemize{
\item{\code{"gprofiler"} : Slower but more species and genes.}
\item{\code{"homologene"} : Faster but fewer species and genes.}
\item{\code{"babelgene"} : Faster but fewer species and genes.
Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{mthreshold}{Maximum number of ortholog names per gene to show.
Passed to \link[gprofiler2]{gorth}.
Only used when \code{method="gprofiler"} (\emph{DEFAULT : }\code{Inf}).}

\item{gene_map}{A \link[base]{data.frame} that maps the current gene names
to new gene names. 
This function's behaviour will adapt to different situations as follows: 
\itemize{
\item{\code{gene_map=<data.frame>} :\cr}{ When a data.frame containing the
gene key:value columns 
(specified by \code{input_col} and \code{output_col}, respectively)
is provided, this will be used to perform aggregation/expansion.}
\item{\code{gene_map=NULL} and \code{input_species!=output_species} :\cr}{
A \code{gene_map} is automatically generated by
 \link[orthogene]{map_orthologs} to perform inter-species 
 gene aggregation/expansion.}
\item{\code{gene_map=NULL} and \code{input_species==output_species} :\cr}{
A \code{gene_map} is automatically generated by
 \link[orthogene]{map_genes} to perform within-species 
 gene gene symbol standardization and aggregation/expansion.}
}}

\item{input_col}{Column name within \code{gene_map} with gene names matching 
the row names of \code{X}.}

\item{output_col}{Column name within \code{gene_map} with gene names
that you wish you map the row names of \code{X} onto.}

\item{verbose}{Print messages.}

\item{...}{Additional arguments to be passed to
\link[gprofiler2]{gorth} or \link[homologene]{homologene}.\cr\cr
\emph{NOTE}: To return only the most "popular"
interspecies ortholog mappings,
supply \code{mthreshold=1} here AND set \code{method="gprofiler"} above.
This procedure tends to yield a greater number of returned genes but at
 the cost of many of them not being true biological 1:1 orthologs.\cr\cr
 For more details, please see
\href{https://cran.r-project.org/web/packages/gprofiler2/vignettes/gprofiler2.html}{
 here}.}
}
\value{
Ortholog map \code{data.frame} with at
 least the columns "input_gene" and "ortholog_gene".
}
\description{
Map orthologs from one species to another.
}
\details{
\code{map_orthologs()} is a core function within
\code{convert_orthologs()}, but does not have many
of the extra checks, such as \code{non121_strategy})
and \code{drop_nonorths}.
}
\examples{
data("exp_mouse")
gene_map <- map_orthologs(
    genes = rownames(exp_mouse),
    input_species = "mouse")
}
