% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregate_mapped_genes.R
\name{aggregate_mapped_genes}
\alias{aggregate_mapped_genes}
\title{Aggregate/expand a gene matrix by gene mappings}
\usage{
aggregate_mapped_genes(
  gene_df,
  gene_map = NULL,
  input_col = "input_gene",
  output_col = "ortholog_gene",
  input_species = "human",
  output_species = input_species,
  method = c("gprofiler", "homologene", "babelgene"),
  agg_fun = "sum",
  agg_method = c("monocle3", "stats"),
  aggregate_orthologs = TRUE,
  transpose = FALSE,
  mthreshold = 1,
  target = "ENSG",
  numeric_ns = "",
  as_integers = FALSE,
  as_sparse = TRUE,
  as_DelayedArray = FALSE,
  dropNA = TRUE,
  sort_rows = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{gene_df}{Input matrix where row names are genes.}

\item{gene_map}{A \link[base]{data.frame} that maps the current gene names
to new gene names. 
This function's behaviour will adapt to different situations as follows: 
\itemize{
\item{\code{gene_map=<data.frame>} :\cr}{ When a data.frame containing the
gene key:value columns 
(specified by \code{input_col} and \code{output_col}, respectively)
is provided, this will be used to perform aggregation/expansion.}
\item{\code{gene_map=NULL} and \code{input_species!=output_species} :\cr}{
A \code{gene_map} is automatically generated by
 \link[orthogene]{map_orthologs} to perform inter-species 
 gene aggregation/expansion.}
\item{\code{gene_map=NULL} and \code{input_species==output_species} :\cr}{
A \code{gene_map} is automatically generated by
 \link[orthogene]{map_genes} to perform within-species 
 gene gene symbol standardization and aggregation/expansion.}
}}

\item{input_col}{Column name within \code{gene_map} with gene names matching 
the row names of \code{X}.}

\item{output_col}{Column name within \code{gene_map} with gene names
that you wish you map the row names of \code{X} onto.}

\item{input_species}{Name of the input species (e.g., "mouse","fly").
Use \link[orthogene]{map_species} to return a full list
of available species.}

\item{output_species}{Name of the output species (e.g. "human","chicken").
Use \link[orthogene]{map_species} to return a full list
 of available species.}

\item{method}{R package to use for gene mapping:
\itemize{
\item{\code{"gprofiler"} : Slower but more species and genes.}
\item{\code{"homologene"} : Faster but fewer species and genes.}
\item{\code{"babelgene"} : Faster but fewer species and genes.
Also gives consensus scores for each gene mapping based on a
 several different data sources.}
}}

\item{agg_fun}{Aggregation function.}

\item{agg_method}{Aggregation method.}

\item{aggregate_orthologs}{[Optional] After performing an initial round of 
many:many aggregation/expansion with \link[orthogene]{many2many_rows},
 ensure each orthologous gene only appears in one row by using the 
\link[orthogene]{aggregate_rows} function (default: \code{TRUE}).}

\item{transpose}{Transpose \code{gene_df} before mapping genes.}

\item{mthreshold}{maximum number of results per initial alias to show. Shows all by default.}

\item{target}{target namespace.}

\item{numeric_ns}{namespace to use for fully numeric IDs (\href{https://biit.cs.ut.ee/gprofiler/page/namespaces-list}{list of available namespaces}).}

\item{as_integers}{Force all values in the matrix to become integers, 
by applying \link[base]{floor} (default: \code{FALSE}).}

\item{as_sparse}{Convert aggregated matrix to sparse matrix.}

\item{as_DelayedArray}{Convert aggregated matrix to
\link[DelayedArray]{DelayedArray}.}

\item{dropNA}{Drop genes assigned to \code{NA} in \code{groupings}.}

\item{sort_rows}{Sort \code{gene_df} rows alphanumerically.}

\item{verbose}{Print messages.}
}
\value{
Aggregated matrix
}
\description{
Aggregate/expand a gene matrix (\code{gene_df}) using a gene mapping 
\link[base]{data.frame} (\code{gene_map}). 
Importantly, mappings can be performed across a variety of scenarios that
can occur during within-species and between-species gene mapping:  
\itemize{
\item{1 gene : 1 gene}
\item{many genes : 1 gene}
\item{1 gene : many genes}
\item{many genes : many genes}
}
For more details on how aggregation/expansion is performed, 
please see: \link[orthogene]{many2many_rows}.
}
\examples{
#### Aggregate within species: gene synonyms ####
data("exp_mouse_enst")                                
X_agg <- aggregate_mapped_genes(gene_df = exp_mouse_enst, 
                                input_species = "mouse")  
                                 
#### Aggregate across species: gene orthologs ####               
data("exp_mouse")
X_agg2 <- aggregate_mapped_genes(gene_df = exp_mouse, 
                                 input_species = "mouse",
                                 output_species = "human",
                                 method="homologene")                                                     
}
