% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/class_result_model.R
\name{signatures}
\alias{signatures}
\alias{signatures,musica-method}
\alias{signatures,result_collection-method}
\alias{signatures,result_model-method}
\alias{signatures<-}
\alias{signatures<-,musica,matrix-method}
\alias{signatures<-,result_collection,matrix-method}
\alias{signatures<-,result_model,matrix-method}
\title{Retrieve signatures from a result_model, result_collection, or musica
object}
\usage{
signatures(x, ...)

\S4method{signatures}{musica}(x, result, modality, model_id)

\S4method{signatures}{result_collection}(x, modality, model_id)

\S4method{signatures}{result_model}(x)

signatures(x, ...) <- value

\S4method{signatures}{musica,matrix}(x, result, modality, model_id) <- value

\S4method{signatures}{result_collection,matrix}(x, modality, model_id) <- value

\S4method{signatures}{result_model,matrix}(x) <- value
}
\arguments{
\item{x}{A \code{\linkS4class{musica}},
\code{\linkS4class{result_collection}}, or \code{\linkS4class{result_model}}
object generated by a mutational discovery or prediction tool.}

\item{...}{Other inputs}

\item{result}{Name of result from result_list to assign the signatures.
Used when \code{result} is a \code{\linkS4class{musica}} object.}

\item{modality}{Modality to assign the signatures. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{model_id}{Model identifier to assign the signatures. Used when
\code{result} is a \code{\linkS4class{musica}} or
\code{\linkS4class{result_collection}} object.}

\item{value}{A matrix of motifs counts by samples}
}
\value{
A matrix of mutational signatures
}
\description{
The \code{signatures} matrix contains the probability of
mutation motif in each sample. Rows correspond to each motif and
columns correspond to each signature.
}
\examples{
data(res)
signatures(res, "result", "SBS96", "res")
data(res)
signatures(res, "result", "SBS96", "res") <- matrix()
}
