#' musica
#'
#' A musica created for testing that includes SBS variants
#'
#' @docType data
#'
#' @usage data(musica)
#'
#' @format An object of class \code{musica}
#' See [create_musica_from_variants()] and [create_musica_from_counts()].
#'
#' @keywords datasets
#'
"musica"

#' musica_annot
#'
#' A musica created for testing that includes SBS variants and sample
#' annotations
#'
#' @docType data
#'
#' @usage data(musica_annot)
#'
#' @format An object of class \code{musica}
#' See [create_musica_from_variants()] and [create_musica_from_counts()].
#'
#' @keywords datasets
#'
"musica_annot"

#' musica_sbs96
#'
#' A musica created for testing that includes SBS variants and a build counts
#' table for them
#'
#' @docType data
#'
#' @usage data(musica_sbs96)
#'
#' @format An object of class \code{musica}
#' See [build_standard_table()].
#'
#' @keywords datasets
#'
"musica_sbs96"

#' musica_sbs96_tiny
#'
#' A very small musica created for testing that includes SBS variants and a
#' build counts table for them
#'
#' @docType data
#'
#' @usage data(musica_sbs96_tiny)
#'
#' @format An object of class \code{musica}
#' See [build_standard_table()].
#'
#' @keywords datasets
#'
"musica_sbs96_tiny"

#' dbs_musica
#'
#' A musica created for testing that includes DBS variants
#'
#' @docType data
#'
#' @usage data(dbs_musica)
#'
#' @format An object of class \code{musica}
#' See [create_musica_from_variants()] and [create_musica_from_counts()].
#'
#' @keywords datasets
#'
"dbs_musica"

#' indel_musica
#'
#' A musica created for testing that includes INDEL variants
#'
#' @docType data
#'
#' @usage data(indel_musica)
#'
#' @format An object of class \code{musica}
#' See [create_musica_from_variants()] and [create_musica_from_counts()].
#'
#' @keywords datasets
#'
"indel_musica"

#' res
#'
#' A musica created for testing that includes SBS variants with discovered
#' exposures and signatures
#'
#' @docType data
#'
#' @usage data(res)
#'
#' @format An object of class \code{musica}
#' See [discover_signatures()].
#'
#' @keywords datasets
#'
"res"

#' res_annot
#'
#' A musica created for testing that includes SBS variants with annotations and
#' discovered exposures and signatures
#'
#' @docType data
#'
#' @usage data(res_annot)
#'
#' @format An object of class \code{musica}
#' See [discover_signatures()].
#'
#' @keywords datasets
#'
"res_annot"
