% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plotDMN.R
\name{plotDMNFit}
\alias{plotDMNFit}
\alias{plotDMN}
\alias{plotDMNFit,SummarizedExperiment-method}
\title{Plotting Dirichlet-Multinomial Mixture Model data}
\usage{
plotDMNFit(x, name = "DMN", type = c("laplace", "AIC", "BIC"), ...)

\S4method{plotDMNFit}{SummarizedExperiment}(x, name = "DMN", type = c("laplace", "AIC", "BIC"))
}
\arguments{
\item{x}{a
\code{\link[SummarizedExperiment:SummarizedExperiment-class]{SummarizedExperiment}}
object contain the DMN data in \code{metadata}.}

\item{name}{\code{Character scalar}. The name to store the result in
\code{\link[SummarizedExperiment:RangedSummarizedExperiment-class]{metadata}}
(Default: \code{"DMN"})}

\item{type}{\code{Character scalar}. The type of measure for access the
goodness of fit. One of \sQuote{laplace}, \sQuote{AIC} or \sQuote{BIC}.}

\item{...}{optional arguments not used.}
}
\value{
\code{plotDMNFit} returns a \code{ggplot2} plot.
}
\description{
To plot DMN fits generated with \code{mia} use \code{plotDMNFit}.
}
\examples{
library(mia)
library(bluster)

# Get dataset
data("peerj13075", package = "mia")
tse <- peerj13075

# Cluster the samples
tse <- addCluster(tse, DmmParam(k = 1:4), name = "DMM", full = TRUE)

# Plot the fit
plotDMNFit(tse, name = "DMM", type = "laplace")

}
\seealso{
\code{\link[mia:calculateDMN]{calculateDMN}}
}
