% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/browseVenn.R
\name{browseVenn}
\alias{browseVenn}
\title{Browse the venn plot}
\usage{
browseVenn(plot, width = NULL, height = NULL)
}
\arguments{
\item{plot}{plots of \link{vennPlot} or \link{upsetPlot}}

\item{width}{width of the figure}

\item{height}{height of the figure}
}
\value{
An object of class htmlwidget that will intelligently print itself
into HTML in a variety of contexts including the R console, within R
Markdown documents, and within Shiny output bindings.
}
\description{
Brow the venn plot in a web browser to adjust the plot and export the result.
}
\examples{
pd <- system.file("extdata", package = "hicVennDiagram", mustWork = TRUE)
fs <- dir(pd, pattern = ".bedpe", full.names = TRUE)
vc <- vennCount(fs)
p <- vennPlot(vc)
browseVenn(p)

}
