% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pointCluster.R
\name{pointCluster}
\alias{pointCluster}
\title{Perform DBSCAN clustering}
\usage{
pointCluster(xyz, eps = "auto", ...)
}
\arguments{
\item{xyz}{A data.frame with x, y, z coordinates}

\item{eps}{The size (radius) of the epsilon neighborhood. Default 'auto'.}

\item{...}{other parameters could be used by dbscan function except x and eps.}
}
\value{
A an object of class dbscan_fast.
}
\description{
Perform DBSCAN clustering for given 3D coordinates.
}
\examples{
xyz <- readRDS(system.file('extdata', '4DNFI1UEG1HD.chr21.FLAMINGO.res.rds',
 package='geomeTriD'))
pc <- pointCluster(xyz)
}
