% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_heatmap}
\alias{plot_heatmap}
\title{plotting heatmap}
\usage{
plot_heatmap(
  multiomics_integration,
  data_table,
  omics,
  scale = "none",
  genes_number = 50,
  samples_number = 50,
  pval = 0.05
)
}
\arguments{
\item{multiomics_integration}{The multiomics integration object.}

\item{data_table}{The data table containing information for the heatmap.}

\item{omics}{The type of omics data for the heatmap.}

\item{scale}{Optional. The scale type for the heatmap. Default is "none".}

\item{genes_number}{Optional. The number of genes to include in the heatmap.
Default is 50.}

\item{samples_number}{Number of samples to include in the heatmap. If this
number is inferior to the total number of samples, the n most variable
samples will be selected}

\item{pval}{Optional. The p-value threshold for significance in the heatmap.
Default is 0.05.}
}
\value{
A heatmap plot.
}
\description{
plotting heatmap
}
\examples{
# Example usage:
library(MultiAssayExperiment)
data("mmultiassay_ov")
tmp <- lapply(experiments(mmultiassay_ov), function(x) x[1:20,])
mmultiassay_ov <- MultiAssayExperiment(experiments = tmp)
# multiomics_integration <- run_multiomics(data = mmultiassay_ov)
# data_table <- extract_model_res(multiomics_integration)
# data_table <- data_table[!is.na(data_table$cnv_met),]
# plot_heatmap(multiomics_integration, data_table, omics = "gene_genomic_res")
}
