% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/methodsInternal.R
\encoding{UTF-8}
\name{removeRootTerm}
\alias{removeRootTerm}
\title{Remove root term if present in the list of selected terms}
\usage{
removeRootTerm(gostResult)
}
\arguments{
\item{gostResult}{a \code{data.frame} containing the terms retained
for the creation of the network.}
}
\value{
a \code{data.frame} of selected terms without the root term.
}
\description{
Remove root term if present in the list of selected terms
}
\examples{

## Loading dataset containing result from an enrichment analysis done with
## gprofiler2
data(demoGOST)

## Only retained the WikiPathways results
results <- demoGOST$result[demoGOST$result$source == "WP", ]

## Remove WIKIPATHWAYS root term
enrichViewNet:::removeRootTerm(gostResult=results)


}
\author{
Astrid Deschênes
}
\keyword{internal}
