% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DittoScatterPlot.R
\name{dittoScatterPlot}
\alias{dittoScatterPlot}
\title{Show RNAseq data overlayed on a scatter plot}
\usage{
dittoScatterPlot(
  object,
  x.var,
  y.var,
  color.var = NULL,
  shape.by = NULL,
  split.by = NULL,
  extra.vars = NULL,
  cells.use = NULL,
  multivar.split.dir = c("col", "row"),
  show.others = FALSE,
  split.show.all.others = TRUE,
  size = 1,
  opacity = 1,
  color.panel = dittoColors(),
  colors = seq_along(color.panel),
  split.nrow = NULL,
  split.ncol = NULL,
  split.adjust = list(),
  assay.x = .default_assay(object),
  slot.x = .default_slot(object),
  adjustment.x = NULL,
  assay.y = .default_assay(object),
  slot.y = .default_slot(object),
  adjustment.y = NULL,
  assay.color = .default_assay(object),
  slot.color = .default_slot(object),
  adjustment.color = NULL,
  assay.extra = .default_assay(object),
  slot.extra = .default_slot(object),
  adjustment.extra = NULL,
  swap.rownames = NULL,
  shape.panel = c(16, 15, 17, 23, 25, 8),
  rename.color.groups = NULL,
  rename.shape.groups = NULL,
  min.color = "#F0E442",
  max.color = "#0072B2",
  min = NA,
  max = NA,
  order = c("unordered", "increasing", "decreasing", "randomize"),
  xlab = x.var,
  ylab = y.var,
  main = "make",
  sub = NULL,
  theme = theme_bw(),
  do.hover = FALSE,
  hover.data = NULL,
  hover.assay = .default_assay(object),
  hover.slot = .default_slot(object),
  hover.adjustment = NULL,
  do.contour = FALSE,
  contour.color = "black",
  contour.linetype = 1,
  add.trajectory.lineages = NULL,
  add.trajectory.curves = NULL,
  trajectory.cluster.meta,
  trajectory.arrow.size = 0.15,
  do.letter = FALSE,
  do.ellipse = FALSE,
  do.label = FALSE,
  labels.size = 5,
  labels.highlight = TRUE,
  labels.repel = TRUE,
  labels.split.by = split.by,
  labels.repel.adjust = list(),
  legend.show = TRUE,
  legend.color.title = "make",
  legend.color.size = 5,
  legend.color.breaks = waiver(),
  legend.color.breaks.labels = waiver(),
  legend.shape.title = shape.by,
  legend.shape.size = 5,
  do.raster = FALSE,
  raster.dpi = 300,
  data.out = FALSE
)
}
\arguments{
\item{object}{A Seurat, SingleCellExperiment, or SummarizedExperiment object.}

\item{x.var, y.var}{Single string giving a gene or metadata that will be used for the x- and y-axis of the scatterplot.
Note: must be continuous.

Alternatively, can be a directly supplied numeric vector of length equal to the total number of cells/samples in \code{object}.}

\item{color.var}{Single string giving a gene or metadata that will set the color of cells/samples in the plot.

Alternatively, can be a directly supplied numeric or string vector or a factor of length equal to the total number of cells/samples in \code{object}.}

\item{shape.by}{Single string giving a metadata (Note: must be discrete.) that will set the shape of cells/samples in the plot.

Alternatively, can be a directly supplied string vector or a factor of length equal to the total number of cells/samples in \code{object}.}

\item{split.by}{1 or 2 strings naming discrete metadata to use for splitting the cells/samples into multiple plots with ggplot faceting.

When 2 metadatas are named, c(row,col), the first is used as rows and the second is used for columns of the resulting grid.

When 1 metadata is named, shape control can be achieved with \code{split.nrow} and \code{split.ncol}}

\item{extra.vars}{String vector providing names of any extra metadata to be stashed in the dataframe supplied to \code{ggplot(data)}.

Useful for making custom alterations \emph{after} dittoSeq plot generation.}

\item{cells.use}{String vector of cells'/samples' names OR an integer vector specifying the indices of cells/samples which should be included.

Alternatively, a Logical vector, the same length as the number of cells in the object, which sets which cells to include.}

\item{multivar.split.dir}{"row" or "col", sets the direction of faceting used for 'var' values when \code{var} is given multiple genes or metadata, and when \code{split.by} is used to provide additional data to facet by.}

\item{show.others}{Logical. FALSE by default, whether other cells should be shown in the background in light gray.}

\item{split.show.all.others}{Logical which sets whether gray "others" cells of facets should include all cells of other facets (\code{TRUE}) versus just cells left out by \code{cell.use} (\code{FALSE}).}

\item{size}{Number which sets the size of data points. Default = 1.}

\item{opacity}{Number between 0 and 1.
Great for when you have MANY overlapping points, this sets how solid the points should be:
1 = not see-through at all. 0 = invisible. Default = 1.
(In terms of typical ggplot variables, = alpha)}

\item{color.panel}{String vector which sets the colors to draw from. \code{dittoColors()} by default, see \code{\link{dittoColors}} for contents.}

\item{colors}{Integer vector, the indexes / order, of colors from color.panel to actually use}

\item{split.nrow, split.ncol}{Integers which set the dimensions of faceting/splitting when a single metadata is given to \code{split.by}.}

\item{split.adjust}{A named list which allows extra parameters to be pushed through to the faceting function call.
List elements should be valid inputs to the faceting functions, e.g. `list(scales = "free")`.

For options, when giving 1 metadata to \code{split.by}, see \code{\link[ggplot2]{facet_wrap}},
OR when giving 2 metadatas to \code{split.by}, see \code{\link[ggplot2]{facet_grid}}.}

\item{assay.x, assay.y, assay.color, assay.extra, slot.x, slot.y, slot.color, slot.extra}{single strings or integers (SCEs and SEs) or an optionally named vector of such values that set which expression data to use for each given data target.
See \code{\link{GeneTargeting}} for specifics and examples -- Seurat and SingleCellExperiment objects deal with these differently, and functionality additions in dittoSeq have led to some minimal divergence from the native methodologies.}

\item{adjustment.x, adjustment.y, adjustment.color, adjustment.extra}{For the given data target, when targeting gene / feature expression, should that data be used directly (default) or should it be adjusted to be
\itemize{
\item{"z-score": scaled with the scale() function to produce a relative-to-mean z-score representation}
\item{"relative.to.max": divided by the maximum expression value to give percent of max values between [0,1]}
}}

\item{swap.rownames}{optionally named string or string vector.
For SummarizedExperiment or SingleCellExperiment objects, its value(s) specifies the column name of rowData(object) to be used to identify features instead of rownames(object).
When targeting multiple modalities (alternative experiments), names can be used to specify which level / alternative experiment (use 'main' for the top-level) individual values should be used for.
See \code{\link{GeneTargeting}} for more specifics and examples.}

\item{shape.panel}{Vector of integers corresponding to ggplot shapes which sets what shapes to use.
When discrete groupings are supplied by \code{shape.by}, this sets the panel of shapes.
When nothing is supplied to \code{shape.by}, only the first value is used.
Default is a set of 6, \code{c(16,15,17,23,25,8)}, the first being a simple, solid, circle.

Note: Unfortunately, shapes can be hard to see when points are on top of each other & they are more slowly processed by the brain.
For these reasons, even as a color blind person myself writing this code, I recommend use of colors for variables with many discrete values.}

\item{rename.color.groups, rename.shape.groups}{String vector containing new names for the identities of the color or shape overlay groups.}

\item{min.color}{color for \code{min} value of \code{color.var} data. Default = yellow}

\item{max.color}{color for \code{max} value of \code{color.var} data. Default = blue}

\item{min, max}{Number which sets the values associated with the minimum or maximum colors.}

\item{order}{String. If the data should be plotted based on the order of the color data, sets whether to plot (from back to front) in "increasing", "decreasing", "randomize" order.
If left as "unordered", plot order is simply based on the order of cells within the \code{object}.}

\item{xlab, ylab}{Strings which set the labels for the axes. To remove, set to \code{NULL}.}

\item{main}{String, sets the plot title.
A default title is automatically generated if based on \code{color.var} and \code{shape.by} when either are provided.
To remove, set to \code{NULL}.}

\item{sub}{String, sets the plot subtitle.}

\item{theme}{A ggplot theme which will be applied before dittoSeq adjustments.
Default = \code{theme_bw()}.
See \url{https://ggplot2.tidyverse.org/reference/ggtheme.html} for other options and ideas.}

\item{do.hover}{Logical which controls whether the object will be converted to a plotly object so that data about individual points will be displayed when you hover your cursor over them.
\code{hover.data} argument is used to determine what data to use.}

\item{hover.data}{String vector of gene and metadata names, example: \code{c("meta1","gene1","meta2","gene2")} which determines what data to show on hover when \code{do.hover} is set to \code{TRUE}.}

\item{hover.assay, hover.slot, hover.adjustment}{Similar to the x, y, color, and extra versions, when showing expression data upon hover, these set what data will be shown.}

\item{do.contour}{Logical. Whether density-based contours should be displayed.}

\item{contour.color}{String that sets the color(s) of the \code{do.contour} contours.}

\item{contour.linetype}{String or numeric which sets the type of line used for \code{do.contour} contours.
Defaults to "solid", but see \code{\link[ggplot2]{linetype}} for other options.}

\item{add.trajectory.lineages}{List of vectors representing trajectory paths, each from start-cluster to end-cluster, where vector contents are the names of clusters provided in the \code{trajectory.cluster.meta} input.

If the \code{\link[slingshot]{slingshot}} package was used for trajectory analysis,
you can provide \code{add.trajectory.lineages = slingLineages('object')}.}

\item{add.trajectory.curves}{List of matrices, each representing coordinates for a trajectory path, from start to end, where matrix columns represent x and y coordinates of the paths.}

\item{trajectory.cluster.meta}{String name of metadata containing the clusters that were used for generating trajectories.  Required when plotting trajectories using the \code{add.trajectory.lineages} method. Names of clusters inside the metadata should be the same as the contents of \code{add.trajectory.lineages} vectors.}

\item{trajectory.arrow.size}{Number representing the size of trajectory arrows, in inches.  Default = 0.15.}

\item{do.letter}{Logical which sets whether letters should be added on top of the colored dots. For extended colorblindness compatibility.
NOTE: \code{do.letter} is ignored if \code{do.hover = TRUE} or \code{shape.by} is provided a metadata because
lettering is incompatible with plotly and with changing the dots' to be different shapes.}

\item{do.ellipse}{Logical. Whether the groups should be surrounded by median-centered ellipses.}

\item{do.label}{Logical. Whether to add text labels near the center (median) of clusters for grouping vars.}

\item{labels.size}{Size of the the labels text}

\item{labels.highlight}{Logical. Whether the labels should have a box behind them}

\item{labels.repel}{Logical, that sets whether the labels' placements will be adjusted with \link{ggrepel} to avoid intersections between labels and plot bounds.
TRUE by default.}

\item{labels.split.by}{String of one or two metadata names which controls the facet-split calculations for label placements.
Defaults to \code{split.by}, so generally there is no need to adjust this except when you are utilizing the \code{extra.vars} input to achieve manual faceting control.}

\item{labels.repel.adjust}{A named list which allows extra parameters to be pushed through to ggrepel function calls.
List elements should be valid inputs to the \code{\link[ggrepel]{geom_label_repel}} by default, or \code{\link[ggrepel]{geom_text_repel}} when \code{labels.highlight = FALSE}.}

\item{legend.show}{Logical. Whether any legend should be displayed. Default = \code{TRUE}.}

\item{legend.color.title, legend.shape.title}{Strings which set the title for the color or shape legends.}

\item{legend.color.size, legend.shape.size}{Numbers representing the size at which shapes should be plotted in the color and shape legends (for discrete variable plotting).
Default = 5. *Enlarging the icons in the colors legend is incredibly helpful for making colors more distinguishable by color blind individuals.}

\item{legend.color.breaks}{Numeric vector which sets the discrete values to label in the color-scale legend for continuous data.}

\item{legend.color.breaks.labels}{String vector, with same length as \code{legend.breaks}, which sets the labels for the tick marks of the color-scale.}

\item{do.raster}{Logical. When set to \code{TRUE}, rasterizes the internal plot layer, changing it from individually encoded points to a flattened set of pixels.
This can be useful for editing in external programs (e.g. Illustrator) when there are many thousands of data points.}

\item{raster.dpi}{Number indicating dots/pixels per inch (dpi) to use for rasterization. Default = 300.}

\item{data.out}{Logical. When set to \code{TRUE}, changes the output, from the plot alone, to a list containing the plot ("p"),
a data.frame containing the underlying data for target cells ("Target_data"),
and a data.frame containing the underlying data for non-target cells ("Others_data").}
}
\value{
a ggplot scatterplot where colored dots and/or shapes represent individual cells/samples. X and Y axes can be gene expression, numeric metadata, or manually supplied values.

Alternatively, if \code{data.out=TRUE}, a list containing three slots is output: the plot (named 'p'), a data.table containing the underlying data for target cells (named 'Target_data'), and a data.table containing the underlying data for non-target cells (named 'Others_data').

Alternatively, if \code{do.hover} is set to \code{TRUE}, the plot is coverted from ggplot to plotly &
cell/sample information, determined by the \code{hover.data} input, is retrieved, added to the dataframe, and displayed upon hovering the cursor over the plot.
}
\description{
Show RNAseq data overlayed on a scatter plot
}
\details{
This function creates a dataframe with X, Y, color, shape, and faceting data determined by \code{x.var}, \code{y.var}, \code{color.var}, \code{shape.var}, and \code{split.by}.
Any extra gene or metadata requested with \code{extra.var} is added as well.
For expression/counts data, \code{assay}, \code{slot}, and \code{adjustment} inputs (\code{.x}, \code{.y}, and \code{.color}) can be used to change which data is used, and if it should be adjusted in some way.

Next, if a set of cells or samples to use is indicated with the \code{cells.use} input, then the dataframe is split into \code{Target_data} and \code{Others_data} based on subsetting by the target cells/samples.

Finally, a scatter plot is created using these dataframes.
Non-target cells are colored in gray if \code{show.others=TRUE},
and target cell data is displayed on top, colored and shaped based on the \code{color.var}- and \code{shape.by}-associated data.
If \code{split.by} was used, the plot will be split into a matrix of panels based on the associated groupings.
}
\section{Many characteristics of the plot can be adjusted using discrete inputs}{

\itemize{
\item \code{size} and \code{opacity} can be used to adjust the size and transparency of the data points.
\item Colors used can be adjusted with \code{color.panel} and/or \code{colors} for discrete data, or \code{min}, \code{max}, \code{min.color}, and \code{max.color} for continuous data.
\item Shapes used can be adjusted with \code{shape.panel}.
\item Color and shape labels can be changed using \code{rename.color.groups} and \code{rename.shape.groups}.
\item Titles and axes labels can be adjusted with \code{main}, \code{sub}, \code{xlab}, \code{ylab}, and \code{legend.title} arguments.
\item Legends can also be adjusted in other ways, using variables that all start with "\code{legend.}" for easy tab completion lookup.
}
}

\examples{
example(importDittoBulk, echo = FALSE)
myRNA

# Mock up some nCount_RNA and nFeature_RNA metadata
#  == the default way to extract
myRNA$nCount_RNA <- runif(60,200,1000)
myRNA$nFeature_RNA <- myRNA$nCount_RNA*runif(60,0.95,1.05)
# and also percent.mito metadata
myRNA$percent.mito <- sample(c(runif(50,0,0.05),runif(10,0.05,0.2)))

dittoScatterPlot(
    myRNA, x.var = "nCount_RNA", y.var = "nFeature_RNA")

# Shapes or colors can be overlaid representing discrete metadata
#   or (only colors) continuous metadata / expression data by providing
#   metadata or gene names to 'color.var' and 'shape.by'
dittoScatterPlot(
    myRNA, x.var = "gene1", y.var = "gene2",
    color.var = "groups",
    shape.by = "SNP",
    size = 3)
dittoScatterPlot(
    myRNA, x.var = "gene1", y.var = "gene2",
    color.var = "gene3")

# Note: scatterplots like this can be very useful for dataset QC, especially
#   with percentage of mitochondrial reads as the color overlay.
dittoScatterPlot(myRNA,
    x.var = "nCount_RNA", y.var = "nFeature_RNA",
    color.var = "percent.mito")

# Data can be "split" or faceted by a discrete variable as well.
dittoScatterPlot(myRNA, x.var = "gene1", y.var = "gene2",
    split.by = "timepoint") # single split.by element
dittoScatterPlot(myRNA, x.var = "gene1", y.var = "gene2",
    split.by = c("groups","SNP")) # row and col split.by elements
# OR with 'extra.vars' plus manually faceting for added control
dittoScatterPlot(myRNA, x.var = "gene1", y.var = "gene2",
    extra.vars = c("SNP")) +
    facet_wrap("SNP", ncol = 1, strip.position = "left")

# Countours can also be added to help illuminate overlapping samples
dittoScatterPlot(myRNA, x.var = "gene1", y.var = "gene2",
    do.contour = TRUE)

# Multiple continuous metadata or genes can also be plotted together by
#   giving that vector to 'color.var':
dittoScatterPlot(myRNA, x.var = "gene1", y.var = "gene2",
    color.var = c("gene3", "gene4"))
# This functionality can be combined with 1 additional 'split.by' variable,
#   with the directionality then controlled via 'multivar.split.dir':
dittoScatterPlot(myRNA, x.var = "gene1", y.var = "gene2",
    color.var = c("gene3", "gene4"),
    split.by = "timepoint",
    multivar.split.dir = "col")
dittoScatterPlot(myRNA, x.var = "gene1", y.var = "gene2",
    color.var = c("gene3", "gene4"),
    split.by = "timepoint",
    multivar.split.dir = "row")

}
\seealso{
\code{\link{getGenes}} and \code{\link{getMetas}} to see what the \code{x.var}, \code{y.var}, \code{color.var}, \code{shape.by}, and \code{hover.data} options are of an \code{object}.

\code{\link{dittoDimPlot}} for making very similar data representations, but where dimensionality reduction (PCA, t-SNE, UMAP, etc.) dimensions are the scatterplot axes.

\code{\link{dittoDimHex}} and \code{\link{dittoScatterHex}} for showing very similar data representations, but where nearby cells are summarized together in hexagonal bins.
}
\author{
Daniel Bunis and Jared Andrews
}
