% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtPackage.R
\name{ExtPackage}
\alias{ExtPackage}
\title{Extension package class}
\description{
A class for generating the skeleton of a new extension package.
}
\details{
This class manages the files of an extension package.

It can generate all the files of a new extension package: DESCRIPTION,
NEWS, README.md, tests, definitons.yml, etc. Optionnaly it also generates
other files like: a \code{.travis.yml} file for Travis-CI, a Makefile for easing
development on UNIX-like platforms outside of Rstudio.

It can also upgrade files of an existing package like: definitions.yml,
Makefile, .travis.yml, LICENSE, etc.
}
\examples{
# Generate a new package:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtPackage$new(path=pkgFolder, dbName='foo.db',
                        dbTitle='Foo database', rcpp=TRUE,
                        connType='mass', entryType='txt', downloadable=TRUE,
                        remote=TRUE)$generate()

}
\section{Super class}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{ExtPackage}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtPackage-new}{\code{ExtPackage$new()}}
\item \href{#method-ExtPackage-clone}{\code{ExtPackage$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtPackage-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtPackage-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtPackage$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See the constructor of ExtGenerator for the parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtPackage-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtPackage-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtPackage$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
