% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtFileGenerator.R
\name{ExtFileGenerator}
\alias{ExtFileGenerator}
\title{Extension file generator abstract class}
\description{
The mother class of all file generators for biodb extension packages.
}
\details{
All file generator classes for biodb extensions must inherit from this class.
}
\examples{
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtConnClass$new(path=pkgFolder, dbName='foo.db',
                        dbTitle='Foo database',
                        connType='mass', remote=TRUE)$generate()

}
\section{Super class}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{ExtFileGenerator}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtFileGenerator-new}{\code{ExtFileGenerator$new()}}
\item \href{#method-ExtFileGenerator-clone}{\code{ExtFileGenerator$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtFileGenerator-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtFileGenerator-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtFileGenerator$new(
  filename = NULL,
  overwrite = FALSE,
  folder = character(),
  template = NULL,
  upgrader = c("fullReplacer", "lineAdder"),
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{filename}}{The name of the generated file.}

\item{\code{overwrite}}{If set to TRUE, then overwrite existing destination file,
even whatever the version of the template file. If set to FALSE,
only overwrite if the version of the template file is strictly
greater than the existing destination file.}

\item{\code{folder}}{The destination subfolder inside the package directory, as
a character vector of subfolders hierarchy.}

\item{\code{template}}{The filename of the template to use.}

\item{\code{upgrader}}{The type of upgrader to use. "fullReplacer" replaces
the whole destination file by the template if it is newer (it compares
version numbers). "lineAdder" only adds to the destination file the
missing lines from the template file.}

\item{\code{...}}{See the constructor of ExtGenerator for the parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtFileGenerator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtFileGenerator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtFileGenerator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
