% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtCpp.R
\name{ExtCpp}
\alias{ExtCpp}
\title{Extension C++ code class}
\description{
A class for generating C++ example files (code & test).
}
\details{
This class generates examples of an R function written in C++ using Rcpp, of
a pure C++ function used to speed up computing, and of C++ code for testing
the pure C++ function.
As for the R function written with Rcpp, it is tested inside standard
testthat R code.
}
\examples{
# Generate C++ files
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtCpp$new(path=pkgFolder)$generate()

}
\section{Super class}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{ExtCpp}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtCpp-new}{\code{ExtCpp$new()}}
\item \href{#method-ExtCpp-clone}{\code{ExtCpp$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtCpp-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtCpp-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtCpp$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See the constructor of ExtGenerator for the parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtCpp-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtCpp-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtCpp$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
