% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExtConnClass.R
\name{ExtConnClass}
\alias{ExtConnClass}
\title{Extension connector clas}
\description{
A class for generating a new connector class.
}
\details{
This class generates a new connector class from given parameters.
The new class inherits from \code{BiodbConn}.
It can be defined as a compound or mass database connector, and made
downloadable, editable and/or writable.
}
\examples{
# Generate a new connector class inside R folder:
pkgFolder <- file.path(tempfile(), 'biodbFoo')
dir.create(pkgFolder, recursive=TRUE)
biodb::ExtConnClass$new(path=pkgFolder, dbName='foo.db',
                        dbTitle='Foo database',
                        connType='mass', remote=TRUE)$generate()

}
\section{Super classes}{
\code{\link[biodb:ExtGenerator]{biodb::ExtGenerator}} -> \code{\link[biodb:ExtFileGenerator]{biodb::ExtFileGenerator}} -> \code{ExtConnClass}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ExtConnClass-new}{\code{ExtConnClass$new()}}
\item \href{#method-ExtConnClass-clone}{\code{ExtConnClass$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="generate"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-generate'><code>biodb::ExtGenerator$generate()</code></a></span></li>
<li><span class="pkg-link" data-pkg="biodb" data-topic="ExtGenerator" data-id="upgrade"><a href='../../biodb/html/ExtGenerator.html#method-ExtGenerator-upgrade'><code>biodb::ExtGenerator$upgrade()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtConnClass-new"></a>}}
\if{latex}{\out{\hypertarget{method-ExtConnClass-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtConnClass$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{See the constructor of ExtFileGenerator for the parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ExtConnClass-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ExtConnClass-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ExtConnClass$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
