% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbRequestSchedulerRule.R
\name{BiodbRequestSchedulerRule}
\alias{BiodbRequestSchedulerRule}
\title{Scheduler rule class.}
\description{
Scheduler rule class.

Scheduler rule class.
}
\details{
This class represents a rule for the request scheduler.
}
\seealso{
\code{\link{BiodbRequestScheduler}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbRequestSchedulerRule-new}{\code{BiodbRequestSchedulerRule$new()}}
\item \href{#method-BiodbRequestSchedulerRule-getHost}{\code{BiodbRequestSchedulerRule$getHost()}}
\item \href{#method-BiodbRequestSchedulerRule-getN}{\code{BiodbRequestSchedulerRule$getN()}}
\item \href{#method-BiodbRequestSchedulerRule-getT}{\code{BiodbRequestSchedulerRule$getT()}}
\item \href{#method-BiodbRequestSchedulerRule-setFrequency}{\code{BiodbRequestSchedulerRule$setFrequency()}}
\item \href{#method-BiodbRequestSchedulerRule-getConnectors}{\code{BiodbRequestSchedulerRule$getConnectors()}}
\item \href{#method-BiodbRequestSchedulerRule-addConnector}{\code{BiodbRequestSchedulerRule$addConnector()}}
\item \href{#method-BiodbRequestSchedulerRule-removeConnector}{\code{BiodbRequestSchedulerRule$removeConnector()}}
\item \href{#method-BiodbRequestSchedulerRule-print}{\code{BiodbRequestSchedulerRule$print()}}
\item \href{#method-BiodbRequestSchedulerRule-waitAsNeeded}{\code{BiodbRequestSchedulerRule$waitAsNeeded()}}
\item \href{#method-BiodbRequestSchedulerRule-recomputeFrequency}{\code{BiodbRequestSchedulerRule$recomputeFrequency()}}
\item \href{#method-BiodbRequestSchedulerRule-computeSleepTime}{\code{BiodbRequestSchedulerRule$computeSleepTime()}}
\item \href{#method-BiodbRequestSchedulerRule-storeCurrentTime}{\code{BiodbRequestSchedulerRule$storeCurrentTime()}}
\item \href{#method-BiodbRequestSchedulerRule-clone}{\code{BiodbRequestSchedulerRule$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-new}{}}}
\subsection{Method \code{new()}}{
Initializer.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$new(host, conn = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{host}}{The web host for which this rules is applicable.}

\item{\code{conn}}{The connector instance that is concerned by this rule.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-getHost"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-getHost}{}}}
\subsection{Method \code{getHost()}}{
Gets host.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$getHost()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns the host.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-getN"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-getN}{}}}
\subsection{Method \code{getN()}}{
Gets N value. The number of connections allowed during a period of
T seconds.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$getN()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns N as an integer.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-getT"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-getT}{}}}
\subsection{Method \code{getT()}}{
Gets T value. The number of seconds during which N connections
are allowed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$getT()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Returns T as a numeric.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-setFrequency"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-setFrequency}{}}}
\subsection{Method \code{setFrequency()}}{
Sets both N and T.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$setFrequency(n, t)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{The number of connections allowed during a period of t seconds,
as an integer.}

\item{\code{t}}{The number of seconds during which n connections are allowed, as a
numeric value.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-getConnectors"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-getConnectors}{}}}
\subsection{Method \code{getConnectors()}}{
Gets connectors associaated with this rule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$getConnectors()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A list of BiodbConn objects.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-addConnector"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-addConnector}{}}}
\subsection{Method \code{addConnector()}}{
Associate a connector with this rule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$addConnector(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A BiodbConn object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-removeConnector"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-removeConnector}{}}}
\subsection{Method \code{removeConnector()}}{
Disassociate a connector from this rule.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$removeConnector(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A BiodbConn instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-print}{}}}
\subsection{Method \code{print()}}{
Displays information about this instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-waitAsNeeded"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-waitAsNeeded}{}}}
\subsection{Method \code{waitAsNeeded()}}{
Wait (sleep) until a new request is allowed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$waitAsNeeded()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-recomputeFrequency"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-recomputeFrequency}{}}}
\subsection{Method \code{recomputeFrequency()}}{
Recompute frequency from submitted N and T values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$recomputeFrequency()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-computeSleepTime"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-computeSleepTime}{}}}
\subsection{Method \code{computeSleepTime()}}{
Compute the needed sleep time to wait until a new request is allowed,
starting from the submitted time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$computeSleepTime(cur.time = Sys.time())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cur.time}}{Time from which to compute needed sleep time.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The needed sleep time in seconds.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-storeCurrentTime"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-storeCurrentTime}{}}}
\subsection{Method \code{storeCurrentTime()}}{
Stores the current time.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$storeCurrentTime(cur.time = Sys.time())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cur.time}}{The current time.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestSchedulerRule-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestSchedulerRule-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestSchedulerRule$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
