% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbRequestScheduler.R
\name{BiodbRequestScheduler}
\alias{BiodbRequestScheduler}
\title{Class for handling requests.}
\description{
Class for handling requests.

Class for handling requests.
}
\details{
This class handles GET and POST requests, as well as file downloading. Each
remote database connection instance creates an instance of
\code{BiodbRequestScheduler} for handling database connection. A timer is
used to schedule connections, and avoid sending too much requests to the
database. This class is not meant to be used directly by the library user.
See section Fields for a list of the constructor's parameters.
}
\examples{
# Create an instance with default settings:
mybiodb <- biodb::newInst()

# Get the scheduler
sched <- mybiodb$getRequestScheduler()

# Create a request object
u <- 'https://www.ebi.ac.uk/webservices/chebi/2.0/test/getCompleteEntity'
url <- BiodbUrl$new(url=u)
url$setParam('chebiId', 15440)
request <- BiodbRequest$new(method='get', url=url)

# Send request
sched$sendRequest(request)

# Terminate instance.
mybiodb$terminate()
mybiodb <- NULL

}
\seealso{
\code{\link{BiodbRequestSchedulerRule}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbRequestScheduler-new}{\code{BiodbRequestScheduler$new()}}
\item \href{#method-BiodbRequestScheduler-sendSoapRequest}{\code{BiodbRequestScheduler$sendSoapRequest()}}
\item \href{#method-BiodbRequestScheduler-sendRequest}{\code{BiodbRequestScheduler$sendRequest()}}
\item \href{#method-BiodbRequestScheduler-downloadFile}{\code{BiodbRequestScheduler$downloadFile()}}
\item \href{#method-BiodbRequestScheduler-notifyConnUrlsUpdated}{\code{BiodbRequestScheduler$notifyConnUrlsUpdated()}}
\item \href{#method-BiodbRequestScheduler-notifyConnSchedulerFrequencyUpdated}{\code{BiodbRequestScheduler$notifyConnSchedulerFrequencyUpdated()}}
\item \href{#method-BiodbRequestScheduler-getUrlString}{\code{BiodbRequestScheduler$getUrlString()}}
\item \href{#method-BiodbRequestScheduler-getUrl}{\code{BiodbRequestScheduler$getUrl()}}
\item \href{#method-BiodbRequestScheduler-findRule}{\code{BiodbRequestScheduler$findRule()}}
\item \href{#method-BiodbRequestScheduler-getConnectorRules}{\code{BiodbRequestScheduler$getConnectorRules()}}
\item \href{#method-BiodbRequestScheduler-registerConnector}{\code{BiodbRequestScheduler$registerConnector()}}
\item \href{#method-BiodbRequestScheduler-unregisterConnector}{\code{BiodbRequestScheduler$unregisterConnector()}}
\item \href{#method-BiodbRequestScheduler-getAllRules}{\code{BiodbRequestScheduler$getAllRules()}}
\item \href{#method-BiodbRequestScheduler-clone}{\code{BiodbRequestScheduler$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. BiodbRequestScheduler class must not be
instantiated direrctly. Instead, use the getRequestScheduler() method from
BiodbMain.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$new(bdb)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{bdb}}{The BiodbMain instance.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-sendSoapRequest"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-sendSoapRequest}{}}}
\subsection{Method \code{sendSoapRequest()}}{
Sends a SOAP request to a URL. Returns the string result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$sendSoapRequest(
  url,
  soap.request,
  soap.action = NA_character_,
  encoding = integer()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The URL to access, as a character string.}

\item{\code{soap.request}}{The XML SOAP request to send, as a character string.}

\item{\code{soap.action}}{The SOAP action to contact, as a character string.}

\item{\code{encoding}}{The encoding to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The results returned by the contacted server, as a single
string value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-sendRequest"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-sendRequest}{}}}
\subsection{Method \code{sendRequest()}}{
Sends a request, and returns content result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$sendRequest(request, cache.read = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{request}}{A BiodbRequest instance.}

\item{\code{cache.read}}{If set to TRUE, the cache system will be used. In case the
same request has already been run and its results saved into the cache, then
the request is not run again, the targeted server not contacted, and the
results are directly loaded from the cache system.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The results returned by the contacted server, as a single string
value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-downloadFile"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-downloadFile}{}}}
\subsection{Method \code{downloadFile()}}{
Downloads the content of a URL and save it into the specified
destination file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$downloadFile(url, dest.file)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The URL to access, as a BiodbUrl object.}

\item{\code{dest.file}}{A path to a destination file.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-notifyConnUrlsUpdated"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-notifyConnUrlsUpdated}{}}}
\subsection{Method \code{notifyConnUrlsUpdated()}}{
Call back function called when connector URLs are changed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$notifyConnUrlsUpdated(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{The connector instance for which the URLs were changed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-notifyConnSchedulerFrequencyUpdated"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-notifyConnSchedulerFrequencyUpdated}{}}}
\subsection{Method \code{notifyConnSchedulerFrequencyUpdated()}}{
Call back function called when connector T and N parameters (frequency) are
changed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$notifyConnSchedulerFrequencyUpdated(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{The connector instance for which the frequency were changed.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-getUrlString"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-getUrlString}{}}}
\subsection{Method \code{getUrlString()}}{
Builds a URL object, using a base URL and parameters to be passed.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$getUrlString(url, params = list())}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{A URL string.}

\item{\code{params}}{A list of URL parameters.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A BiodUrl object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-getUrl"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-getUrl}{}}}
\subsection{Method \code{getUrl()}}{
Sends a request and get the result.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$getUrl(
  url,
  params = list(),
  method = c("get", "post"),
  header = character(),
  body = character(),
  encoding = integer()
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{A URL string.}

\item{\code{params}}{A list of URL parameters.}

\item{\code{method}}{The method to use. Either 'get' or 'post'.}

\item{\code{header}}{The header to send.}

\item{\code{body}}{The body to send.}

\item{\code{encoding}}{The encoding to use.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The results of the request.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-findRule"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-findRule}{}}}
\subsection{Method \code{findRule()}}{
Searches for a rule by host name.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$findRule(url, create = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{url}}{The host URL.}

\item{\code{create}}{Sets to TRUE to create a rule when none exists.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A BiodbRequestSchedulerRule object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-getConnectorRules"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-getConnectorRules}{}}}
\subsection{Method \code{getConnectorRules()}}{
Gets the rules associates with a connector.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$getConnectorRules(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A valid connector object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of rules.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-registerConnector"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-registerConnector}{}}}
\subsection{Method \code{registerConnector()}}{
Registers a new connector with the scheduler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$registerConnector(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A valid connector object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-unregisterConnector"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-unregisterConnector}{}}}
\subsection{Method \code{unregisterConnector()}}{
Unregisters a connector from this scheduler.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$unregisterConnector(conn)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn}}{A valid connector object.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-getAllRules"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-getAllRules}{}}}
\subsection{Method \code{getAllRules()}}{
Gets all defined rules.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$getAllRules()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The list of all rules.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbRequestScheduler-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbRequestScheduler-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbRequestScheduler$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
