% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BiodbMain.R
\name{BiodbMain}
\alias{BiodbMain}
\title{The central class of the biodb package.}
\description{
The central class of the biodb package.

The central class of the biodb package.
}
\details{
The main class of the \code{biodb} package.
In order to use the biodb package, you need first to create an instance of
this class.

The constructor takes a single argument, \code{autoloadExtraPkgs}, to enable
(\code{TRUE} or default) or disable (\code{FALSE}) autoloading of extra
biodb packages.

Once the instance is created, some other important classes
(\code{BiodbFactory}, \code{BiodbPersistentCache}, \code{BiodbConfig}, ...)
are instantiated (just once) and their instances are later accessible through
get*() methods.
}
\examples{
# Create an instance:
mybiodb <- biodb::newInst()

# Get the factory instance
fact <- mybiodb$getFactory()

# Terminate instance.
mybiodb$terminate()
mybiodb <- NULL

}
\seealso{
\code{\link{BiodbFactory}}, \code{\link{BiodbPersistentCache}},
\code{\link{BiodbConfig}}, \code{\link{BiodbEntryFields}},
\code{\link{BiodbDbsInfo}}.
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-BiodbMain-new}{\code{BiodbMain$new()}}
\item \href{#method-BiodbMain-terminate}{\code{BiodbMain$terminate()}}
\item \href{#method-BiodbMain-loadDefinitions}{\code{BiodbMain$loadDefinitions()}}
\item \href{#method-BiodbMain-getConfig}{\code{BiodbMain$getConfig()}}
\item \href{#method-BiodbMain-getPersistentCache}{\code{BiodbMain$getPersistentCache()}}
\item \href{#method-BiodbMain-getDbsInfo}{\code{BiodbMain$getDbsInfo()}}
\item \href{#method-BiodbMain-getEntryFields}{\code{BiodbMain$getEntryFields()}}
\item \href{#method-BiodbMain-getFactory}{\code{BiodbMain$getFactory()}}
\item \href{#method-BiodbMain-getRequestScheduler}{\code{BiodbMain$getRequestScheduler()}}
\item \href{#method-BiodbMain-addObservers}{\code{BiodbMain$addObservers()}}
\item \href{#method-BiodbMain-getObservers}{\code{BiodbMain$getObservers()}}
\item \href{#method-BiodbMain-convertEntryIdFieldToDbClass}{\code{BiodbMain$convertEntryIdFieldToDbClass()}}
\item \href{#method-BiodbMain-entriesFieldToVctOrLst}{\code{BiodbMain$entriesFieldToVctOrLst()}}
\item \href{#method-BiodbMain-entriesToDataframe}{\code{BiodbMain$entriesToDataframe()}}
\item \href{#method-BiodbMain-entryIdsToDataframe}{\code{BiodbMain$entryIdsToDataframe()}}
\item \href{#method-BiodbMain-addColsToDataframe}{\code{BiodbMain$addColsToDataframe()}}
\item \href{#method-BiodbMain-entriesToJson}{\code{BiodbMain$entriesToJson()}}
\item \href{#method-BiodbMain-collapseRows}{\code{BiodbMain$collapseRows()}}
\item \href{#method-BiodbMain-entriesToSingleFieldValues}{\code{BiodbMain$entriesToSingleFieldValues()}}
\item \href{#method-BiodbMain-entryIdsToSingleFieldValues}{\code{BiodbMain$entryIdsToSingleFieldValues()}}
\item \href{#method-BiodbMain-computeFields}{\code{BiodbMain$computeFields()}}
\item \href{#method-BiodbMain-saveEntriesAsJson}{\code{BiodbMain$saveEntriesAsJson()}}
\item \href{#method-BiodbMain-copyDb}{\code{BiodbMain$copyDb()}}
\item \href{#method-BiodbMain-print}{\code{BiodbMain$print()}}
\item \href{#method-BiodbMain-fieldIsAtomic}{\code{BiodbMain$fieldIsAtomic()}}
\item \href{#method-BiodbMain-getFieldClass}{\code{BiodbMain$getFieldClass()}}
\item \href{#method-BiodbMain-clone}{\code{BiodbMain$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-new"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-new}{}}}
\subsection{Method \code{new()}}{
New instance initializer. The BiodbMain must not be instantiated directly.
Instead use the newInst() global method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$new(autoloadExtraPkgs = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{autoloadExtraPkgs}}{Set to TRUE to allow automatic loading of extension
packages. Set to FALSE to forbid it. If left to NULL, the default,
autoload.extra.pkgs configuration value will be used.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-terminate"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-terminate}{}}}
\subsection{Method \code{terminate()}}{
Closes \\code{BiodbMain} instance. Call this method when you are done with
your \\code{BiodbMain} instance.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$terminate()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-loadDefinitions"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-loadDefinitions}{}}}
\subsection{Method \code{loadDefinitions()}}{
Loads databases and entry fields definitions from YAML file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$loadDefinitions(file, package = "biodb")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{file}}{The path to a YAML file containing definitions for
\\code{BiodbMain} (databases, fields or configuration keys).}

\item{\code{package}}{The package to which belong the new definitions.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-getConfig"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-getConfig}{}}}
\subsection{Method \code{getConfig()}}{
Returns the single instance of the \\code{BiodbConfig} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$getConfig()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The instance of the \\code{BiodbConfig} class attached to
this BiodbMain instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-getPersistentCache"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-getPersistentCache}{}}}
\subsection{Method \code{getPersistentCache()}}{
Returns the single instance of the BiodbPersistentCache class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$getPersistentCache()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The instance of the BiodbPersistentCache class attached to
this BiodbMain instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-getDbsInfo"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-getDbsInfo}{}}}
\subsection{Method \code{getDbsInfo()}}{
Returns the single instance of the \\code{BiodbDbsInfo} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$getDbsInfo()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The instance of the \\code{BiodbDbsInfo} class attached to
this BiodbMain instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-getEntryFields"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-getEntryFields}{}}}
\subsection{Method \code{getEntryFields()}}{
Returns the single instance of the \\code{BiodbEntryFields} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$getEntryFields()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The instance of the \\code{BiodbEntryFields} class
attached to this BiodbMain instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-getFactory"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-getFactory}{}}}
\subsection{Method \code{getFactory()}}{
Returns the single instance of the \\code{BiodbFactory} class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$getFactory()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The instance of the \\code{BiodbFactory} class attached to
this BiodbMain instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-getRequestScheduler"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-getRequestScheduler}{}}}
\subsection{Method \code{getRequestScheduler()}}{
Returns the single instance of the \\code{BiodbRequestScheduler}
class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$getRequestScheduler()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The instance of the \\code{BiodbRequestScheduler} class
attached to this BiodbMain instance.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-addObservers"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-addObservers}{}}}
\subsection{Method \code{addObservers()}}{
Adds new observers. Observers will be called each time an event
occurs. This is the way used in biodb to get feedback about what is going
inside biodb code.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$addObservers(observers)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{observers}}{Either an object or a list of objects.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-getObservers"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-getObservers}{}}}
\subsection{Method \code{getObservers()}}{
Gets the list of registered observers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$getObservers()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
The list or registered observers.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-convertEntryIdFieldToDbClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-convertEntryIdFieldToDbClass}{}}}
\subsection{Method \code{convertEntryIdFieldToDbClass()}}{
Gets the database class name corresponding to an entry ID field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$convertEntryIdFieldToDbClass(entry.id.field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entry.id.field}}{The name of an ID field. It must end with \".id\".}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-entriesFieldToVctOrLst"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-entriesFieldToVctOrLst}{}}}
\subsection{Method \code{entriesFieldToVctOrLst()}}{
Extracts the value of a field from a list of entries. Returns either a
vector or a list depending on the type of the field.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$entriesFieldToVctOrLst(
  entries,
  field,
  flatten = FALSE,
  compute = TRUE,
  limit = 0,
  withNa = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entries}}{A list of \\code{BiodbEntry} instances.}

\item{\code{field}}{The name of a field.}

\item{\code{flatten}}{If set to \\code{TRUE} and the field has a cardinality
greater than one, then values be converted into a vector of class
character in which each entry values are collapsed.}

\item{\code{compute}}{If set to \\code{TRUE}, computable fields will be
output.}

\item{\code{limit}}{The maximum number of values to retrieve for each entry.
Set to 0 to get all values.}

\item{\code{withNa}}{If set to TRUE, keep NA values. Otherwise filter out NAs
values in vectors.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A vector if the field is atomic or flatten is set to
\\code{TRUE}, otherwise a list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-entriesToDataframe"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-entriesToDataframe}{}}}
\subsection{Method \code{entriesToDataframe()}}{
Converts a list of entries or a list of list of entries
(\\code{BiodbEntry} objects) into a data frame.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$entriesToDataframe(
  entries,
  only.atomic = TRUE,
  null.to.na = TRUE,
  compute = TRUE,
  fields = NULL,
  limit = 0,
  drop = FALSE,
  sort.cols = FALSE,
  flatten = TRUE,
  only.card.one = FALSE,
  own.id = TRUE,
  prefix = ""
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entries}}{A list of \\code{BiodbEntry} instances or a list of list of
\\code{BiodbEntry} instances.}

\item{\code{only.atomic}}{If set to \\code{TRUE}, output only atomic fields, i.e.:
the fields whose value type is one of integer, numeric, logical or
character.}

\item{\code{null.to.na}}{If set to \\code{TRUE}, each \\code{NULL} entry in the
list is converted into a row of NA values.}

\item{\code{compute}}{If set to \\code{TRUE}, computable fields will be output.}

\item{\code{fields}}{A character vector of field names to output. The data frame
output will be restricted to this list of fields.}

\item{\code{limit}}{The maximum number of field values to write into new columns.
Used for fields that can contain more than one value. Set it to 0 to get all
values.}

\item{\code{drop}}{If set to \\code{TRUE} and the resulting data frame has only one
column, a vector will be output instead of data frame.}

\item{\code{sort.cols}}{Sort columns in alphabetical order.}

\item{\code{flatten}}{If set to \\code{TRUE}, then each field with a cardinality
greater than one, will be converted into a vector of class character whose
values are collapsed.}

\item{\code{only.card.one}}{Output only fields whose cardinality is one.}

\item{\code{own.id}}{If set to TRUE includes the database id field named
\verb{<database_name>.id} whose values are the same as the \code{accession} field.}

\item{\code{prefix}}{Insert a prefix at the start of all field names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing the entries. Columns are named
according to field names.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-entryIdsToDataframe"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-entryIdsToDataframe}{}}}
\subsection{Method \code{entryIdsToDataframe()}}{
Construct a data frame using entry IDs and field values of the
corresponding entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$entryIdsToDataframe(
  ids,
  db,
  fields = NULL,
  limit = 3,
  prefix = "",
  own.id = FALSE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{A character vector of entry IDs or a list of character vectors of
entry IDs.}

\item{\code{db}}{The biodb database name for the entry IDs, or a connector ID, as a
sinle character value.}

\item{\code{fields}}{A character vector containing entry fields to add.}

\item{\code{limit}}{The maximum number of field values to write into new columns.
Used for fields that can contain more than one value. Set it to 0 to get all
values.}

\item{\code{prefix}}{Insert a prefix at the start of all field names.}

\item{\code{own.id}}{If set to TRUE includes the database id field named
\verb{<database_name>.id} whose values are the same as the \code{accession} field.}

\item{\code{A}}{data frame containing in columns the requested field
values, with one entry per line, in the same order than in \code{ids} vector.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-addColsToDataframe"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-addColsToDataframe}{}}}
\subsection{Method \code{addColsToDataframe()}}{
Add values from a database to an existing data frame using a column
containing entry identifiers.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$addColsToDataframe(x, id.col, db, fields, limit = 3, prefix = "")}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A data frame containing at least one column with Biodb entry IDs
identified by the parameter \code{id.col}.}

\item{\code{id.col}}{The name of the column containing IDs inside the input data
frame.}

\item{\code{db}}{The biodb database name for the entry IDs, or a connector ID, as a
single character value.}

\item{\code{fields}}{A character vector containing entry fields to add.}

\item{\code{limit}}{The maximum number of field values to write into new columns.
Used for fields that can contain more than one value. Set it to 0 to get all
values.}

\item{\code{prefix}}{Insert a prefix at the start of all field names.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame containing \code{x} and new columns appended for the fields
requested.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-entriesToJson"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-entriesToJson}{}}}
\subsection{Method \code{entriesToJson()}}{
Converts a list of \\code{BiodbEntry} objects into JSON. Returns a vector of
characters.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$entriesToJson(entries, compute = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entries}}{A list of \\code{BiodbEntry} instances. It may contain NULL
elements.}

\item{\code{compute}}{If set to \\code{TRUE}, computable fields will added to JSON
too.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A list of JSON strings, the same length as entries list.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-collapseRows"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-collapseRows}{}}}
\subsection{Method \code{collapseRows()}}{
Collapses rows of a data frame, by looking for duplicated values in the
reference columns (parameter \code{cols}). The values contained in the reference
columns are supposed to be ordered inside the data frame, in the sens that
all duplicated values are supposed to directly follow the original values.
For all rows containing duplicated values, we look at values in all other
columns and concatenate values in each column containing different values.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$collapseRows(x, sep = "|", cols = 1L)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A data frame.}

\item{\code{sep}}{The separator to use when concatenating values in collapsed rows.}

\item{\code{cols}}{The indices or the names of the columns used as reference.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A data frame, with rows collapsed."
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-entriesToSingleFieldValues"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-entriesToSingleFieldValues}{}}}
\subsection{Method \code{entriesToSingleFieldValues()}}{
Extract all values of a field from a list of entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$entriesToSingleFieldValues(
  entries,
  field,
  sortOutput = FALSE,
  uniq = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entries}}{A list of BiodbEntry objects.}

\item{\code{field}}{The field for which to extract values.}

\item{\code{sortOutput}}{Set to TRUE to sort the values.}

\item{\code{uniq}}{Set to TRUE to remove duplicates.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The values of the field as a vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-entryIdsToSingleFieldValues"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-entryIdsToSingleFieldValues}{}}}
\subsection{Method \code{entryIdsToSingleFieldValues()}}{
Extract all values of a field from a list of entries.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$entryIdsToSingleFieldValues(
  ids,
  db,
  field,
  sortOutput = FALSE,
  uniq = TRUE
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{ids}}{A list of entry identifiers.}

\item{\code{db}}{The database ID or connector ID where to find the entries.}

\item{\code{field}}{The field for which to extract values.}

\item{\code{sortOutput}}{Set to TRUE to sort the values.}

\item{\code{uniq}}{Set to TRUE to remove duplicates.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The values of the field as a vector.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-computeFields"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-computeFields}{}}}
\subsection{Method \code{computeFields()}}{
Computes missing fields in entries, for those fields that are
comptable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$computeFields(entries)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entries}}{A list of \\code{BiodbEntry} instances. It may contain NULL
elements.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-saveEntriesAsJson"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-saveEntriesAsJson}{}}}
\subsection{Method \code{saveEntriesAsJson()}}{
Saves a list of entries in JSON format. Each entry will be saved in a
separate file.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$saveEntriesAsJson(entries, files, compute = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{entries}}{A list of \\code{BiodbEntry} instances. It may contain NULL
elements.}

\item{\code{files}}{A character vector of file paths, the same length as entries
list.}

\item{\code{compute}}{If set to \\code{TRUE}, computable fields will be saved too.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-copyDb"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-copyDb}{}}}
\subsection{Method \code{copyDb()}}{
Copies all entries of a database into another database. The connector of the
destination database must be editable.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$copyDb(conn.from, conn.to, limit = 0)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{conn.from}}{The connector of the source datababase to copy.}

\item{\code{conn.to}}{The connector of the destination database.}

\item{\code{limit}}{The number of entries of the source database to copy. If set to
\\code{NULL}, copy the whole database.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-print"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-print}{}}}
\subsection{Method \code{print()}}{
Prints object information.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$print()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
Nothing.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-fieldIsAtomic"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-fieldIsAtomic}{}}}
\subsection{Method \code{fieldIsAtomic()}}{
DEPRECATED method to test if a field is an atomic field. The new
method is \\code{BiodbEntryField :isVector()}."
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$fieldIsAtomic(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
TRUE if the field's value is atomic.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-getFieldClass"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-getFieldClass}{}}}
\subsection{Method \code{getFieldClass()}}{
DEPRECATED method to get the class of a field. The new method is
\code{BiodbMain :getEntryFields()$get(field)$getClass()}.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$getFieldClass(field)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{field}}{The name of the field.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
The class of the field.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-BiodbMain-clone"></a>}}
\if{latex}{\out{\hypertarget{method-BiodbMain-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{BiodbMain$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
