% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_linda.R
\name{set_linda}
\alias{set_linda}
\title{set_linda}
\usage{
set_linda(
  assay_name = "counts",
  formula = NULL,
  contrast = NULL,
  is.winsor = TRUE,
  outlier.pct = 0.03,
  zero.handling = c("pseudo-count", "imputation"),
  pseudo.cnt = 0.5,
  alpha = 0.05,
  p.adj.method = "BH",
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{formula}{Character. For example: formula = '~x1*x2+x3+(1|id)'. At least one fixed effect is required.}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{is.winsor}{Boolean. If TRUE (default), the Winsorization process will be conducted for the OTU table.}

\item{outlier.pct}{A real value between 0 and 1; Winsorization cutoff (percentile) for the OTU table, e.g., 0.03. Default is NULL. If NULL, Winsorization process will not be conducted.}

\item{zero.handling}{Character. Specifies the method to handle zeros in the OTU table. Options are "pseudo-count" or "imputation" (default is "pseudo-count"). If "imputation", zeros in the OTU table will be imputed using the formula in the referenced paper. If "pseudo-count", a small constant (pseudo.cnt) will be added to each value in the OTU table.}

\item{pseudo.cnt}{A positive real value. Default is 0.5. If zero.handling is set to "pseudo-count", this constant will be added to each value in the OTU table.}

\item{alpha}{A real value between 0 and 1; significance level of differential abundance. Default is 0.05.}

\item{p.adj.method}{Character; p-value adjusting approach. See R function p.adjust. Default is 'BH'.}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE}).}
}
\value{
A named list containing the set of parameters for \code{DA_linda}
method.
}
\description{
Set the parameters for linda differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for ANCOM with bias correction
base_linda <- set_linda(formula = "~ group", contrast = c("group", "B", "A"), 
    zero.handling = "pseudo-count", expand = TRUE)
many_linda <- set_linda(formula = "~ group", contrast = c("group", "B", "A"), 
    is.winsor = c(TRUE, FALSE), 
    zero.handling = c("pseudo-count", "imputation"), expand = TRUE)
}
\seealso{
\code{\link{DA_linda}}
}
