% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_corncob.R
\name{set_corncob}
\alias{set_corncob}
\title{set_corncob}
\usage{
set_corncob(
  assay_name = "counts",
  pseudo_count = FALSE,
  formula = NULL,
  phi.formula = NULL,
  formula_null = NULL,
  phi.formula_null = NULL,
  test = c("Wald", "LRT"),
  boot = FALSE,
  coefficient = NULL,
  expand = TRUE
)
}
\arguments{
\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{formula}{an object of class \code{formula} without the response: a
symbolic description of the model to be fitted to the abundance.}

\item{phi.formula}{an object of class \code{formula} without the response: a
symbolic description of the model to be fitted to the dispersion.}

\item{formula_null}{Formula for mean under null, without response}

\item{phi.formula_null}{Formula for overdispersion under null, without response}

\item{test}{Character. Hypothesis testing procedure to use. One of
\code{"Wald"} or \code{"LRT"} (likelihood ratio test).}

\item{boot}{Boolean. Defaults to \code{FALSE}. Indicator of whether or not to
use parametric bootstrap algorithm. (See \code{\link[corncob]{pbWald}} and
\code{\link[corncob]{pbLRT}}).}

\item{coefficient}{The coefficient of interest as a single word formed by the
variable name and the non reference level. (e.g.: 'ConditionDisease' if the
reference level for the variable 'Condition' is 'control').}

\item{expand}{logical, if TRUE create all combinations of input parameters
(default \code{expand = TRUE})}
}
\value{
A named list containing the set of parameters for \code{DA_corncob}
method.
}
\description{
Set the parameters for corncob differential abundance detection method.
}
\examples{
# Set some basic combinations of parameters for corncob
base_corncob <- set_corncob(formula = ~ group, phi.formula = ~ group,
    formula_null = ~ 1, phi.formula_null = ~ group, coefficient = "groupB")
# Set many possible combinations of parameters for corncob
all_corncob <- set_corncob(pseudo_count = c(TRUE, FALSE), formula = ~ group,
    phi.formula = ~ group, formula_null = ~ 1, phi.formula_null = ~ group,
    coefficient = "groupB", boot = c(TRUE, FALSE))
}
\seealso{
\code{\link{DA_corncob}}
}
