% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DA_basic.R
\name{DA_basic}
\alias{DA_basic}
\title{DA_basic}
\usage{
DA_basic(
  object,
  assay_name = "counts",
  pseudo_count = FALSE,
  contrast = NULL,
  test = c("t", "wilcox"),
  paired = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{object}{a phyloseq or TreeSummarizedExperiment object.}

\item{assay_name}{the name of the assay to extract from the 
TreeSummarizedExperiment object (default \code{assayName = "counts"}). Not 
used if the input object is a phyloseq.}

\item{pseudo_count}{add 1 to all counts if TRUE (default
\code{pseudo_count = FALSE}).}

\item{contrast}{character vector with exactly, three elements: a string 
indicating the name of factor whose levels are the conditions to be 
compared, the name of the level of interest, and the name of the other 
level.}

\item{test}{name of the test to perform. Choose between "t" or "wilcox".}

\item{paired}{boolean. Choose whether the test is paired or not (default 
\code{paired = FALSE}). If \code{paired = TRUE} be sure to provide the 
object properly ordered (by the grouping variable).}

\item{verbose}{an optional logical value. If \code{TRUE}, information about
the steps of the algorithm is printed. Default \code{verbose = TRUE}.}
}
\value{
A list object containing the matrix of p-values `pValMat`,
a matrix of summary statistics for each tag `statInfo`, and a suggested 
`name` of the final object considering the parameters passed to the 
function.
}
\description{
Fast run for basic differential abundance detection methods such as wilcox 
and t tests.
}
\examples{
set.seed(1)
# Create a very simple phyloseq object
counts <- matrix(rnbinom(n = 60, size = 3, prob = 0.5), nrow = 10, ncol = 6)
metadata <- data.frame("Sample" = c("S1", "S2", "S3", "S4", "S5", "S6"),
                       "group" = as.factor(c("A", "A", "A", "B", "B", "B")))
ps <- phyloseq::phyloseq(phyloseq::otu_table(counts, taxa_are_rows = TRUE),
                         phyloseq::sample_data(metadata))
# Differential abundance
DA_basic(object = ps, pseudo_count = FALSE, contrast = c("group", "B", "A"),
    test = "t", verbose = FALSE)
}
\seealso{
\code{\link{DA_Seurat}} for a similar implementation of basic 
tests.
}
