% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/contactsUMI4C.R
\name{.singleAlignmentUMI4C}
\alias{.singleAlignmentUMI4C}
\title{Align split fastq file}
\usage{
.singleAlignmentUMI4C(
  split_file,
  align_dir,
  threads = 1,
  bowtie_index,
  pos_viewpoint,
  filter_bp = 1e+07
)
}
\arguments{
\item{split_file}{Split fastq file to align.}

\item{align_dir}{Directory where to save aligned files.}

\item{threads}{Number of threads to use in the analysis. Default=1.}

\item{bowtie_index}{Path and prefix of the bowtie index to use for the
alignment.}

\item{pos_viewpoint}{GRanges object containing the genomic position of the
viewpoint.}

\item{filter_bp}{Integer indicating the bp upstream and downstream of the
viewpoint to select for further analysis. Default=10e6}
}
\value{
Creates a BAM file in \code{wk_dir/align} named
"\code{basename(fastq))_filtered.bam}", containing the aligned filtered
reads. A data.frame object with the statisitics is also returned.
}
\description{
Align split fastq file
}
