% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visualization.R
\name{oncoprint}
\alias{oncoprint}
\title{oncoprint}
\usage{
oncoprint(
  x,
  excl.sort = TRUE,
  samples.cluster = FALSE,
  genes.cluster = FALSE,
  file = NA,
  ann.stage = has.stages(x),
  ann.hits = TRUE,
  stage.color = "YlOrRd",
  hits.color = "Purples",
  null.color = "lightgray",
  border.color = "white",
  text.cex = 1,
  font.column = NA,
  font.row = NA,
  title = as.description(x),
  sample.id = FALSE,
  hide.zeroes = FALSE,
  legend = TRUE,
  legend.cex = 0.5,
  cellwidth = NA,
  cellheight = NA,
  group.by.label = FALSE,
  group.by.stage = FALSE,
  group.samples = NA,
  gene.annot = NA,
  gene.annot.color = "Set1",
  show.patterns = FALSE,
  annotate.consolidate.events = FALSE,
  txt.stats = paste(nsamples(x), " samples\\n", nevents(x), " events\\n", ngenes(x),
    " genes\\n", npatterns(x), " patterns", sep = ""),
  gtable = FALSE,
  ...
)
}
\arguments{
\item{x}{A TRONCO compliant dataset}

\item{excl.sort}{Boolean value, if TRUE sorts samples to enhance exclusivity of alterations}

\item{samples.cluster}{Boolean value, if TRUE clusters samples (columns). Default FALSE}

\item{genes.cluster}{Boolean value, if TRUE clusters genes (rows). Default FALSE}

\item{file}{If not NA write to \code{file} the Oncoprint, default is NA (just visualization).}

\item{ann.stage}{Boolean value to annotate stage classification, default depends on \code{x}}

\item{ann.hits}{Boolean value to annotate the number of events in each sample, default is TRUE}

\item{stage.color}{RColorbrewer palette to color stage annotations. Default is 'YlOrRd'}

\item{hits.color}{RColorbrewer palette to color hits annotations. Default is 'Purples'}

\item{null.color}{Color for the Oncoprint cells with 0s, default is 'lightgray'}

\item{border.color}{Border color for the Oncoprint, default is white' (no border)}

\item{text.cex}{Title and annotations cex, multiplied by font size 7}

\item{font.column}{If NA, half of font.row is used}

\item{font.row}{If NA, max(c(15 * exp(-0.02 * nrow(data)), 2)) is used, where data is the data 
visualized in the Oncoprint}

\item{title}{Oncoprint title, default is as.name(x) - see \code{as.name}}

\item{sample.id}{If TRUE shows samples name (columns). Default is FALSE}

\item{hide.zeroes}{If TRUE trims data - see \code{trim} - before plot. Default is FALSE}

\item{legend}{If TRUE shows a legend for the types of events visualized. Defualt is TRUE}

\item{legend.cex}{Default 0.5; determines legend size if \code{legend = TRUE}}

\item{cellwidth}{Default NA, sets autoscale cell width}

\item{cellheight}{Default NA, sets autoscale cell height}

\item{group.by.label}{Sort samples (rows) by event label - usefull when multiple events per gene are
available}

\item{group.by.stage}{Default FALSE; sort samples by stage.}

\item{group.samples}{If this samples -> group map is provided, samples are grouped as of groups
and sorted according to the number of mutations per sample - usefull when \code{data} was clustered}

\item{gene.annot}{Genes'groups, e.g. list(RAF=c('KRAS','NRAS'), Wnt=c('APC', 'CTNNB1')). Default is NA.}

\item{gene.annot.color}{Either a RColorColorbrewer palette name or a set of custom colors matching names(gene.annot)}

\item{show.patterns}{If TRUE shows also a separate oncoprint for each pattern. Default is FALSE}

\item{annotate.consolidate.events}{Default is FALSE. If TRUE an annotation for events to consolidate is shown.}

\item{txt.stats}{By default, shows a summary statistics for shown data (n,m, |G| and |P|)}

\item{gtable}{If TRUE return the gtable object}

\item{...}{other arguments to pass to pheatmap}
}
\description{
oncoPrint : plot a genotype. For details and examples 
regarding the visualization through oncoprints, we refer to the Vignette Section 4.4.
}
