% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readSpatialOverlay.R
\name{readSpatialOverlay}
\alias{readSpatialOverlay}
\title{Read in \code{\linkS4class{SpatialOverlay}} from tiff file and annotations}
\usage{
readSpatialOverlay(
  ometiff,
  annots,
  slideName,
  image = FALSE,
  res = NULL,
  saveFile = FALSE,
  outline = TRUE,
  ...,
  segCol = NULL
)
}
\arguments{
\item{ometiff}{path to OME-TIFF}

\item{annots}{path to annotation file: can be labWorksheet, DA excel file, or 
delimted file}

\item{slideName}{name of slide}

\item{image}{should image be extracted from OME-TIFF}

\item{res}{resolution of image 
1 = largest, higher number = smaller
This value will affect the coordinates of the overlays. 
res = 2, resolution is 1/2 the size as the raw image
res = 3, resolution is 1/4 the size as the raw image
res = 4, resolution is 1/8 the size as the raw image 
resolution = 1/2^(res-1)}

\item{saveFile}{should xml & image be saved, file is saved in working
directory with same name as OME-TIFF}

\item{outline}{returned coordinates only contain outlinearies, 
will not work for segmented ROIs}

\item{...}{additional parameters for `readLabWorksheet` like `roiCol` and `slideCol`}

\item{segCol}{additional parameter for `annotMatching` if default search doesn't work. 
For default search, set to NULL}
}
\value{
\code{\linkS4class{SpatialOverlay}} of slide
}
\description{
Create an instance of class \code{\linkS4class{SpatialOverlay}} 
by reading data from OME-TIFF and annotation sheet.
}
\examples{

muBrain_GxT <- readRDS(unzip(system.file("extdata", "muBrain_GxT.zip", 
                         package = "SpatialOmicsOverlay")))

image <- downloadMouseBrainImage()

muBrain <- readSpatialOverlay(ometiff = image, annots = muBrain_GxT[,1:5], 
                              slideName = "D5761 (3)", image = TRUE, res = 8, 
                              saveFile = FALSE, outline = FALSE)

}
\seealso{
\code{\link{SpatialOverlay-class}}
}
