% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/process.files.R
\name{ProcessMultipleFiles}
\alias{ProcessMultipleFiles}
\title{Converts multiple files into a concatenated data frame}
\usage{
ProcessMultipleFiles(files, transform = "asinh", numcells = 10000,
  norm = FALSE, scale = FALSE, input, name.multiple.donors = FALSE)
}
\arguments{
\item{files}{a vector of file names (name = "anything_condition.fcs")}

\item{transform}{set to asinh if you want to do an asinh transform of
all markers in the dataset}

\item{numcells}{desiered number of cells in the matrix, set at 10k}

\item{norm}{boolean that quantile normalizes the data if true}

\item{scale}{boolean that converts all values to z scores if true}

\item{input}{the static markers that will be used downstream in knn
computation. These are included here to include the option of per-marker
quantile normalization, in the event norm is set to TRUE}

\item{name.multiple.donors}{boolean indicating whether multiple donors
will be distinguished (as a separate "patient" column)}
}
\value{
result: a combined file set
}
\description{
This is tailored to a very specific file format for unstim/stim
Files need the following name convention: "xxxx_stim.fcs"
Files where you want to name the patients need the following convention:
"xxxx__patientID_stim.fcs"
}
\examples{
file1 <- system.file("extdata", "Bendall_et_al_Cell_Sample_C_basal.fcs",
    package = "Sconify")
file2 <- system.file("extdata", "Bendall_et_al_Cell_Sample_C_IL7.fcs",
    package = "Sconify")
ProcessMultipleFiles(c(file1, file2), input = input.markers)
}
