% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{runTPCA}
\alias{runTPCA}
\title{Run the TPCA analysis}
\usage{
runTPCA(
  objList,
  complexAnno = NULL,
  ppiAnno = NULL,
  rownameCol = NULL,
  summaryMethodStr = "median",
  distMethodStr = "euclidean",
  doRocAnalysis = TRUE,
  minCount = 3,
  nSamp = 10000,
  p_adj_method = "BH"
)
}
\arguments{
\item{objList}{inout list of objects, e.g.
ExpressionSets retrieved after TPP data import
or matrices or data frames}

\item{complexAnno}{data frame annotating
known protein complexes of interest to test}

\item{ppiAnno}{data frame annotation known
protein-protein interactions (PPI) to test}

\item{rownameCol}{in case the input objects are tibbles
this parameter takes in the name (character) of the column 
specifying protein names or ids}

\item{summaryMethodStr}{character string indicating a method 
to use to summarize measurements across replicates, 
default is "median", other options are c("mean", "rbind")}

\item{distMethodStr}{method to use within dist function,
default is 'euclidean'}

\item{doRocAnalysis}{logical indicating whether a ROC 
analysis should be performed which can be used to assess 
the predictive power of the dataset for protein-protein
interactions / protein complexes based on distanc between
melting curves of protein interactions partners}

\item{minCount}{integer indicating how many subunits 
of a complex should be qunatified to inlucde it into the
analysis, default is 3}

\item{nSamp}{integer indicating the number of random samples
which should be performed to estimate empirical null 
distributions, default is 10000}

\item{p_adj_method}{character string indicating a valid 
method to be used for multiple testing adjusment, default 
is "BH" which makes p.adjust use benjamini-hochberg, for 
additional options check ?p.adjust}
}
\value{
an object of class tpcaResult
with the following slots:
1) ObjList: containing the supplied list of
objects
}
\description{
Run the TPCA analysis
}
\examples{
 
m1 <- matrix(1:12, ncol = 4)
m2 <- matrix(2:13, ncol = 4)
m3 <- matrix(c(2:10, 1:7), ncol = 4)

rownames(m1) <- 1:3
rownames(m2) <- 2:4
rownames(m3) <- 2:5

colnames(m1) <- paste0("X", 1:4)
colnames(m2) <- paste0("X", 1:4)
colnames(m3) <- paste0("X", 1:4)

mat_list <- list(
    m1, m2, m3
)

ppi_anno <- tibble(
    x = "2",
    y = "3",
    combined_score = 700,
    pair = "2:3")

runTPCA(
    objList = mat_list,
    complexAnno = NULL,
    ppiAnno = ppi_anno
)
}
