% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NanoStringGeoMxSet-autoplot.R
\name{plotNormFactorConcordance}
\alias{plotNormFactorConcordance}
\title{Generate concordance figure of normalization factors based on user provided factors}
\usage{
plotNormFactorConcordance(object, plotFactor, normfactors = NULL)
}
\arguments{
\item{object}{name of the object class to subset
\enumerate{
    \item{NanoStringGeoMxSet, use the NanoStringGeoMxSet class}
}}

\item{plotFactor}{segment factor to color the plot by}

\item{normfactors}{normalization factors from computeNormalizationFactors(). If NULL these are calculated automatically.}
}
\description{
For use with protein data ONLY.

Upper panels are the concordance plot.
Lower panels are the standard deviation of the log2-ratios between the normalization factors
}
\examples{
proteinData <- readRDS(file= system.file("extdata","DSP_Proteogenomics_Example_Data", 
"proteinData.rds", package = "GeomxTools"))

normConcord <- plotNormFactorConcordance(object = proteinData, plotFactor = "Segment_Type")
normConcord

}
