% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peak_info.R
\name{peak_info}
\alias{peak_info}
\title{Summary of Peak Information}
\usage{
peak_info(peaklist, blacklist)
}
\arguments{
\item{peaklist}{A named list of peak files as GRanges object.
Objects listed using \code{list("name1" = peak, "name2" = peak2)}.}

\item{blacklist}{A GRanges object containing blacklisted regions.}
}
\value{
A summary table of peak information
}
\description{
This function outputs a table summarizing information on the peak files.
Provides the total number of peaks and the percentage of peaks in blacklisted
 regions.
}
\examples{
### Load Data ###
data("encode_H3K27ac") # example peakfile GRanges object
data("CnT_H3K27ac") # example peakfile GRanges object
data("hg19_blacklist") # example blacklist GRanges object

### Named Peaklist ###
peaklist <- list("encode"=encode_H3K27ac, "CnT"=CnT_H3K27ac)

### Run ###
df <- peak_info(peaklist = peaklist,
                blacklist = hg19_blacklist) 
}
