% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_button.R
\name{download_button}
\alias{download_button}
\title{Download local file}
\source{
\href{https://github.com/fmmattioni/downloadthis/issues/31}{
csv2 Issue.}

\href{https://github.com/fmmattioni/downloadthis/issues/16}{
Plotly Issue}
}
\usage{
download_button(
  object,
  save_output = FALSE,
  outfile_dir = NULL,
  filename = NULL,
  button_label = paste0("Download: ", "<code>", filename, "</code>"),
  output_extension = ".rds",
  icon = "fa fa-save",
  button_type = "success",
  self_contained = TRUE,
  add_download_button = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{object}{\R object to serialize.}

\item{save_output}{Default FALSE. If TRUE, all outputs (tables and plots) of
the analysis will be saved in a folder (EpiCompare_file).}

\item{outfile_dir}{Directory to save the file to.}

\item{filename}{Name of the file to save.}

\item{button_label}{Character (HTML), button label}

\item{output_extension}{Extension of the output file. Currently,  \code{.csv},
\code{.xlsx}, and \code{.rds} are supported. If a (named) list is passed to the
function, only \code{.xlsx} and \code{.rds} are supported.}

\item{icon}{Fontawesome tag e.g.: "fa fa-save"}

\item{button_type}{Character, one of the standard Bootstrap types}

\item{self_contained}{A boolean to specify whether your HTML output is
self-contained. Default to \code{FALSE}.}

\item{add_download_button}{Add download buttons for each plot or dataset.}

\item{verbose}{Print messages.}
}
\value{
Download button as HTML text.
}
\description{
Save an object as RDS and create a download button that can be rendered to
 Rmarkdown HTML pages.
Uses the package \pkg{downloadthis}.
}
\examples{
button <- download_button(object=mtcars)
}
