% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{CnT_H3K27ac}
\alias{CnT_H3K27ac}
\title{Example CUT&Tag peak file}
\format{
An object of class \code{GRanges} of length 1670.
}
\source{
The code to prepare the .Rda file from the raw peak file is:

\code{# sequences were directly downloaded from 
https://trace.ncbi.nlm.nih.gov/Traces/sra/?run=SRR8383507} \cr
\code{# and peaks (BED file) were generated by Leyla Abbasova 
(Neurogenomics Lab, Imperial College London)} \cr
\code{CnT_H3K27ac <- ChIPseeker::readPeakFile("path", as = "GRanges")} \cr
\code{CnT_H3K27ac <- CnT_H3K27ac[seqnames(CnT_H3K27ac)== "chr1"]} \cr
\code{my_label <- 
c("name","score","strand","signalValue","pValue","qValue","peak")} \cr
\code{colnames(GenomicRanges::mcols(CnT_H3K27ac)) <- my_label} \cr
\code{usethis::use_data(CnT_H3K27ac)} \cr
}
\usage{
data("CnT_H3K27ac")
}
\description{
Human H3K27ac peak file generated with CUT&Tag using K562 cell-line from
Kaya-Okur et al., (2019). Human genome build hg19 was used.
Raw peak file (.BED) was obtained from GEO
(\url{https://trace.ncbi.nlm.nih.gov/Traces/sra/?run=SRR8383507}).
Peak calling was performed by Leyla Abbasova using MACS2.
The peak file was then imported as an GRanges object.
Peaks located on chromosome 1 were subsetted to reduce the dataset size.
}
\keyword{datasets}
