% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estCutoffs.R
\name{estCutoffs}
\alias{estCutoffs}
\title{Estimation of distance separation cutoffs}
\usage{
estCutoffs(x)
}
\arguments{
\item{x}{a \code{\link[SingleCellExperiment]{SingleCellExperiment}}.}
}
\value{
the input \code{SingleCellExperiment} is returned
with an additional \code{metadata} slot \code{sep_cutoffs}.
}
\description{
For each sample, estimates a cutoff parameter for 
the distance between positive and negative barcode populations.
}
\details{
For the estimation of cutoff parameters, we considered yields
upon debarcoding as a function of the applied cutoffs. 
Commonly, this function will be characterized by an initial weak decline, 
where doublets are excluded, and subsequent rapid decline in yields to zero. 
In between, low numbers of counts with intermediate barcode separation 
give rise to a plateau. As an adequate cutoff estimate, 
we target the point that approximately marks the end of the plateau regime 
and the onset of yield decline. To facilitate robust cutoff estimation, 
we fit a linear and a three-parameter log-logistic function 
to the yields function:
\deqn{f(x)=\frac{d}{1+e^{b(log(x)-log(e))}}}{
f(x) = d / (1 + exp(b * (log(x) - log(e))))}
The goodness of the linear fit relative to the log-logistic fit 
is weighed with:
\deqn{w=\frac{RSS_{log-logistic}}{RSS_{log-logistic}+RSS_{linear}}}{
w = RSS(log-logistic) / (RSS(log-logistic) + RSS(linear))}
and the cutoffs for both functions are defined as:
\deqn{c_{linear}=-\frac{\beta_0}{2\beta_1}}{
c(linear) = - beta0 / (2 * beta1)}
\deqn{c_{log-logistic}=argmin_x\{\frac{\vert f'(x)\vert}{
f(x)}>0.1\}}{c(log-logistic) = argmin x { | f'(x) | / f(x) > 0.1 }}
The final cutoff estimate is defined as the weighted mean 
between these estimates:
\deqn{c=(1-w)\cdot c_{log-logistic}+w\cdot c_{linear}}{
c = (1 - w) x c(log-logistic) + w x c(linear)}
}
\examples{
library(SingleCellExperiment)

# construct SCE
data(sample_ff, sample_key)
sce <- prepData(sample_ff)
    
# assign preliminary barcode IDs
# & estimate separation cutoffs
sce <- assignPrelim(sce, sample_key)
sce <- estCutoffs(sce)

# access separation cutoff estimates
(seps <- metadata(sce)$sep_cutoffs)

# compute population yields
cs <- split(seq_len(ncol(sce)), sce$bc_id)
sapply(names(cs), function(id) {
  sub <- sce[, cs[[id]]]
  mean(sub$delta > seps[id])
})

# view yield plots including current cutoff
plotYields(sce, which = "A1")

}
\references{
Finney, D.J. (1971). Probit Analsis. 
\emph{Journal of Pharmaceutical Sciences} \bold{60}, 1432.
}
\author{
Helena L Crowell \email{helena.crowell@uzh.ch}
}
