% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nmr_meta.R
\name{nmr_meta_add}
\alias{nmr_meta_add}
\alias{nmr_meta_add_tidy_excel}
\title{Add metadata to an nmr_dataset object}
\usage{
nmr_meta_add(nmr_data, metadata, by = "NMRExperiment")

nmr_meta_add_tidy_excel(nmr_data, excel_file)
}
\arguments{
\item{nmr_data}{an \link{nmr_dataset_family} object}

\item{metadata}{A data frame with metadata to add}

\item{by}{A column name of both the \code{nmr_data$metadata$external} and the metadata
data.frame. If you want to merge two columns with different headers you can
use a named character vector \code{c("NMRExperiment" = "ExperimentNMR")} where
the left side is the column name of the \code{nmr_data$metadata$external} and the right side is
the column name of the metadata data frame.}

\item{excel_file}{Path to a tidy Excel file name. The Excel can consist
of multiple sheets, that are added sequentially. The first column of the first
sheet MUST be named as one of the metadata already present in the dataset,
typically will be "NMRExperiment". The rest of the columns of the first sheet
can be named at will. Similary, the first column of the second sheet must be
named as one of the metadata already present in the dataset, typically
"NMRExperiment" or any of the columns of the first sheet. The rest of the columns
of the second sheet can be named at will. See the package vignette for an
example.}
}
\value{
The nmr_dataset_family object with the added metadata
}
\description{
This is useful to add metadata to datasets that can be later used for
plotting spectra or further analysis (PCA...).
}
\examples{
# Load a demo dataset with four samples:
dataset <- system.file("dataset-demo", package = "AlpsNMR")
nmr_dataset <- nmr_read_samples_dir(dataset)

# At first we just have the NMRExperiment column
nmr_meta_get(nmr_dataset, groups = "external")
# Get a table with NMRExperiment -> SubjectID
dummy_metadata <- system.file("dataset-demo", "dummy_metadata.xlsx", package = "AlpsNMR")
NMRExp_SubjID <- readxl::read_excel(dummy_metadata, sheet = 1)

NMRExp_SubjID
# We can link the SubjectID column of the first excel into the dataset
nmr_dataset <- nmr_meta_add(nmr_dataset, NMRExp_SubjID, by = "NMRExperiment")
nmr_meta_get(nmr_dataset, groups = "external")
# The second excel can use the SubjectID:
SubjID_Age <- readxl::read_excel(dummy_metadata, sheet = 2)
SubjID_Age
# Add the metadata by its SubjectID:
nmr_dataset <- nmr_meta_add(nmr_dataset, SubjID_Age, by = "SubjectID")
# The final loaded metadata:
nmr_meta_get(nmr_dataset, groups = "external")

# Read a tidy excel file:

dataset <- system.file("dataset-demo", package = "AlpsNMR")
nmr_dataset <- nmr_read_samples_dir(dataset)

# At first we just have the NMRExperiment column
nmr_meta_get(nmr_dataset, groups = "external")
# Get a table with NMRExperiment -> SubjectID
dummy_metadata <- system.file("dataset-demo", "dummy_metadata.xlsx", package = "AlpsNMR")

nmr_dataset <- nmr_meta_add_tidy_excel(nmr_dataset, dummy_metadata)
# Updated Metadata:
nmr_meta_get(nmr_dataset, groups = "external")
}
\seealso{
Other metadata functions: 
\code{\link{Pipelines}},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_meta_groups}()}

Other nmr_dataset functions: 
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()}

Other nmr_dataset_1D functions: 
\code{\link{[.nmr_dataset_1D}()},
\code{\link{format.nmr_dataset_1D}()},
\code{\link{get_integration_with_metadata}()},
\code{\link{is.nmr_dataset_1D}()},
\code{\link{nmr_integrate_peak_positions}()},
\code{\link{nmr_integrate_regions}()},
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()},
\code{\link{nmr_ppm_resolution}()},
\code{\link{print.nmr_dataset_1D}()}

Other nmr_dataset_peak_table functions: 
\code{\link{nmr_meta_export}()},
\code{\link{nmr_meta_get}()},
\code{\link{nmr_meta_get_column}()}
}
\concept{metadata functions}
\concept{nmr_dataset functions}
\concept{nmr_dataset_1D functions}
\concept{nmr_dataset_peak_table functions}
