% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/batman_helpers.R
\name{nmr_batman_options}
\alias{nmr_batman_options}
\title{Batman Options helper}
\usage{
nmr_batman_options(
  ppmRange = matrix(c(3, 3.1, 3.6, 3.7, 3.9, 4, 4, 4.1, 6.95, 7.05, 7.6, 7.7, 7.8, 7.9),
    ncol = 2, byrow = TRUE),
  specNo = "1",
  paraProc = 4L,
  negThresh = -0.5,
  scaleFac = 1e+06,
  downSamp = 1,
  hiresFlag = 1,
  randSeed = 100025L,
  nItBurnin = 200L,
  nItPostBurnin = 5000L,
  multFile = 2L,
  thinning = 50L,
  cfeFlag = 0,
  nItRerun = 5000L,
  startTemp = 1000,
  specFreq = 600,
  a = 1e-05,
  b = 1e-09,
  muMean = 1.1,
  muVar = 0.2,
  muVar_prop = 0.002,
  nuMVar = 0.0025,
  nuMVarProp = 0.1,
  tauMean = -0.05,
  tauPrec = 2,
  rdelta = 0.02,
  csFlag = 0
)
}
\arguments{
\item{ppmRange}{Range of ppm to process}

\item{specNo}{Index of spectra to process}

\item{paraProc}{Number of cores to use}

\item{negThresh}{Truncation threshold for negative intensities}

\item{scaleFac}{Divide each spectrum by this number}

\item{downSamp}{Decimate each spectrum by this factor}

\item{hiresFlag}{Keep High Resolution deconvolved spectra}

\item{randSeed}{A random seed}

\item{nItBurnin}{Number of burn-in iterations}

\item{nItPostBurnin}{Number of iterations after burn-in}

\item{multFile}{Multiplet file (integer)}

\item{thinning}{Save MCMC state every thinning iterations}

\item{cfeFlag}{Same concentration for all spectra (fixed effect)}

\item{nItRerun}{Number of iterations for a batman rerun}

\item{startTemp}{Start temperature}

\item{specFreq}{NMR Spectrometer frequency}

\item{a}{Shape parameter for the gamma distribution (used for lambda, the precision)}

\item{b}{Rate distribution parameter for the gamma distribution (used for lambda, the precision)}

\item{muMean}{Peak width mean in ln(Hz)}

\item{muVar}{Peak width variance in ln(Hz)}

\item{muVar_prop}{Peak width proposed variance in ln(Hz)}

\item{nuMVar}{Peak width metabolite variance in ln(Hz)}

\item{nuMVarProp}{Peak width metabolite proposed variance in ln(Hz)}

\item{tauMean}{mean of the prior on tau}

\item{tauPrec}{inverse of variance of prior on tau}

\item{rdelta}{Truncation of the prior on peak shift (ppm)}

\item{csFlag}{Specify chemical shift for each multiplet in each spectrum? (chemShiftperSpectra.csv file)}
}
\value{
A batman_options object with the Batman Options
}
\description{
Batman Options helper
}
\examples{
bopts <- nmr_batman_options()
}
\seealso{
Other batman functions: 
\code{\link{nmr_batman}}
}
\concept{batman functions}
