% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Services.R, R/Leonardo.R, R/Terra.R, R/Rawls.R,
%   R/Dockstore.R, R/TDR.R
\docType{data}
\name{Services}
\alias{Services}
\alias{.DollarNames.Service}
\alias{operations,Service-method}
\alias{schemas,Service-method}
\alias{show,Service-method}
\alias{Service-class}
\alias{empty_object}
\alias{operations}
\alias{schemas}
\alias{tags}
\alias{$,Service-method}
\alias{Leonardo}
\alias{Leonardo-class}
\alias{operations,Leonardo-method}
\alias{Terra}
\alias{Terra-class}
\alias{operations,Terra-method}
\alias{schemas,Terra-method}
\alias{Rawls}
\alias{Rawls-class}
\alias{operations,Rawls-method}
\alias{schemas,Rawls-method}
\alias{Dockstore}
\alias{Dockstore-class}
\alias{operations,Dockstore-method}
\alias{TDR}
\alias{TDR-class}
\alias{operations,TDR-method}
\title{RESTful services useful for AnVIL developers}
\usage{
empty_object

operations(x, ..., .deprecated = FALSE)

\S4method{operations}{Service}(x, ..., auto_unbox = FALSE, .deprecated = FALSE)

schemas(x)

tags(x, .tags, .deprecated = FALSE)

\S4method{$}{Service}(x, name)

Leonardo()

Terra()

Rawls()

Dockstore()

TDR()
}
\arguments{
\item{x}{A \code{Service} instance, usually a singleton provided by the
package and documented on this page, e.g., \code{leonardo} or
\code{terra}.}

\item{...}{additional arguments passed to methods or, for
\verb{operations,Service-method}, to the internal \code{get_operation()}
function.}

\item{.deprecated}{optional logical(1) include deprecated operations?}

\item{auto_unbox}{logical(1) If FALSE (default) do not
automatically 'unbox' R scalar values from JSON arrays to JSON
scalers.}

\item{.tags}{optional character() of tags to use to filter operations.}

\item{name}{A symbol representing a defined operation, e.g.,
\code{leonardo$listRuntimes()}.}
}
\value{
\code{empty_object} returns a representation to be used as
arguments in function calls expecting the empty json object
\code{{}}.

\code{Leonardo()} creates the API of the Leonardo container
deployment service at
\url{https://leonardo.dsde-prod.broadinstitute.org/api-docs.yaml}.

\code{Terra()} creates the API of the Terra cloud computational
environemnt at \url{https://api.firecloud.org/}.

\code{Rawls()} creates the API of the Rawls cloud computational
environemnt at \url{https://rawls.dsde-prod.broadinstitute.org}.

\code{Dockstore()} represents the API of the Dockstore platform to
share Docker-based tools in CWL or WDL or Nextflow at
\url{https://dockstore.org}

\code{TDR()} creates the API of the Terra Data Repository to work with
snapshot data in the Terra Data Repository at \url{https://data.terra.bio}.
}
\description{
RESTful services useful for AnVIL developers
}
\details{
Note the services \code{Terra()}, \code{Rawls()}, and \code{Leonardo()} require the
\code{AnVILGCP} package for authentication to the Google Cloud Platform. See
\code{?AnVILGCP::gcloud_access_token()} for details.

When using \code{$} to select a service, some arguments appear
in 'body' of the REST request. Specify these using the
\verb{.__body__=} argument, as illustrated for
\code{createBillingProjectFull()}, below.
}
\examples{
empty_object

library(AnVILGCP)
if (gcloud_exists()) {
    ## Arguments to be used as the 'body' (`.__body__=`) of a REST query
    Terra()$createBillingProjectFull       # 6 arguments...
    args(Terra()$createBillingProjectFull) # ... passed as `.__body__ = list(...)`
}
library(AnVILGCP)
if (gcloud_exists())
    Leonardo()

library(AnVILGCP)
if (gcloud_exists()) {
    tags(Terra())
    tags(Terra(), "Billing")
}

library(AnVILGCP)
if (gcloud_exists()) {
    tags(Rawls())
    tags(Rawls(), "billing")
}

Dockstore()

library(AnVILGCP)
if (gcloud_exists())
    TDR()

}
\keyword{datasets}
