% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Service.R
\name{Service}
\alias{Service}
\title{RESTful service constructor}
\usage{
Service(
  service,
  host,
  config = httr::config(),
  authenticate = TRUE,
  api_url = character(),
  package = "AnVIL",
  schemes = "https",
  api_reference_url = api_url,
  api_reference_md5sum = character(),
  api_reference_version = character(),
  api_reference_headers = NULL
)
}
\arguments{
\item{service}{character(1) The \code{Service} class name, e.g., \code{"terra"}.}

\item{host}{character(1) host name that provides the API resource,
e.g., \code{"leonardo.dsde-prod.broadinstitute.org"}.}

\item{config}{httr::config() curl options}

\item{authenticate}{logical(1) use credentials from authentication
service file 'auth.json' in the specified package?}

\item{api_url}{optional character(1) url location of OpenAPI
\code{.json} or \code{.yaml} service definition.}

\item{package}{character(1) (default \code{AnVIL}) The package where
'api.json' yaml and (optionally) 'auth.json' files are located.}

\item{schemes}{character(1) (default 'https') Specifies the
transfer protocol supported by the API service.}

\item{api_reference_url}{character(1) path to reference API. See
Details.}

\item{api_reference_md5sum}{character(1) the result of
\code{tools::md5sum()} applied to the reference API.}

\item{api_reference_version}{character(1) the version of the
reference API. This is used to check that the version of the
service matches the version of the reference API. It is usally
set by the service generation function,. e.g., \code{AnVIL::Rawls()}.}

\item{api_reference_headers}{character() header(s) to be used
(e.g., \code{c(Authorization = paste("Bearer", token))}) when
retrieving the API reference for validation.}
}
\value{
An object of class \code{Service}.
}
\description{
RESTful service constructor
}
\details{
This function creates a RESTful interface to a service
provided by a host, e.g., "leonardo.dsde-prod.broadinstitute.org".
The function requires an OpenAPI \code{.json} or \code{.yaml} specifcation
as well as an (optional) \code{.json} authentication token. These files
are located in the source directory of a pacakge, at
\verb{<package>/inst/service/<service>/api.json} and
\verb{<package>/inst/service/<service>/auth.json}, or at \code{api_url}.

When provided, the \code{api_reference_md5sum} is used to check that
the file described at \code{api_reference_url} has the same checksum
as an author-validated version.

The service is usually a singleton, created at the package
level during \code{.onLoad()}.
}
\examples{
.MyService <- setClass("MyService", contains = "Service")

MyService <- function() {
    .MyService(Service("my_service", host="my.api.org"))
}

}
