% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot.nmr_dataset_1D}
\alias{plot.nmr_dataset_1D}
\title{Plot an nmr_dataset_1D}
\usage{
\method{plot}{nmr_dataset_1D}(
  x,
  NMRExperiment = NULL,
  chemshift_range = NULL,
  interactive = FALSE,
  quantile_plot = NULL,
  quantile_colors = NULL,
  ...
)
}
\arguments{
\item{x}{a \link{nmr_dataset_1D} object}

\item{NMRExperiment}{A character vector with the NMRExperiments to include. Use "all" to include all experiments.}

\item{chemshift_range}{range of the chemical shifts to be included. Can be of length 3
to include the resolution in the third element (e.g. \code{c(0.2, 0.8, 0.005)})}

\item{interactive}{if \code{TRUE} return an interactive plotly plot, otherwise return a ggplot one.}

\item{quantile_plot}{If \code{TRUE} plot the 10\\%, 50\\%, 90\\% percentiles of the spectra as reference.
If two numbers between 0 and 1 are given then a custom percentile can be plotted}

\item{quantile_colors}{A vector with the colors for each of the quantiles}

\item{...}{arguments passed to \link[ggplot2:aes]{ggplot2::aes} (or to \link[ggplot2:aes_]{ggplot2::aes_string}, being deprecated).}
}
\value{
The plot
}
\description{
Plot an nmr_dataset_1D
}
\examples{
dir_to_demo_dataset <- system.file("dataset-demo", package = "AlpsNMR")
# dataset <- nmr_read_samples_dir(dir_to_demo_dataset)
# dataset_1D <- nmr_interpolate_1D(dataset, axis = c(min = -0.5, max = 10, by = 2.3E-4))
# plot(dataset_1D)

}
\seealso{
Other plotting functions: 
\code{\link{plot_interactive}()}
}
\concept{plotting functions}
