Example input files can be found in the ``inst/extdata`` folder of the
MaAsLin 3 source.

* ``abundance_spike_in_ex.tsv`` is the abundance table generated from a 
modified version of SparseDOSSA 2 as documented here:
https://github.com/willnickols/maaslin3_benchmark. SparseDOSSA 2 uses
a zero-inflated log-linear abundance model to generate microbiome profiles
based on user-defined metadata and effect sizes. This procedure was modified
to include an extra feature with a recorded absolute abundance before
transforming the feature table to relative abundances.
* ``abundance_total_ex.tsv`` is the abundance table generated from a 
modified version of SparseDOSSA 2 as documented here:
https://github.com/willnickols/maaslin3_benchmark. SparseDOSSA 2 uses
a zero-inflated log-linear abundance model to generate microbiome profiles
based on user-defined metadata and effect sizes. This procedure was modified
to record the total absolute abundance before
transforming the feature table to relative abundances.
* ``HMP2_metadata.tsv``: a tab-delimited file with samples as rows and
metadata as columns. It is a subset of the full HMP2 metadata available at
https://www.ibdmdb.org/results that includes a subset of fields that
are of interest.
* ``HMP2_taxonomy.tsv``: a tab-delimited file with samples as rows and
species as columns. It is a subset of the full HMP2 taxonomic profiles table
generated by MetaPhlAn 4 (https://huttenhower.sph.harvard.edu/metaphlan/) from
sequencing data available at https://www.ibdmdb.org/results. The table 
includes a subset of taxa that are of interest.
* ``metadata_spike_in_ex.tsv`` is the metadata table generated from a 
modified version of SparseDOSSA 2 as documented here:
https://github.com/willnickols/maaslin3_benchmark. SparseDOSSA 2 uses
a zero-inflated log-linear abundance model to generate microbiome profiles
based on user-defined metadata and effect sizes. This procedure was modified
to include an extra feature with a recorded absolute abundance before
transforming the feature table to relative abundances.
* ``metadata_total_ex.tsv`` is the metadata table generated from a 
modified version of SparseDOSSA 2 as documented here:
https://github.com/willnickols/maaslin3_benchmark. SparseDOSSA 2 uses
a zero-inflated log-linear abundance model to generate microbiome profiles
based on user-defined metadata and effect sizes. This procedure was modified
to record the total absolute abundance before
transforming the feature table to relative abundances.
* ``scaling_factors_spike_in_ex.tsv`` is the spike-in table generated from a 
modified version of SparseDOSSA 2 as documented here:
https://github.com/willnickols/maaslin3_benchmark. SparseDOSSA 2 uses
a zero-inflated log-linear abundance model to generate microbiome profiles
based on user-defined metadata and effect sizes. This procedure was modified
to include an extra feature with a recorded absolute abundance before
transforming the feature table to relative abundances.
* ``scaling_factors_total_ex.tsv`` is the total per-sample abundance table 
generated from a modified version of SparseDOSSA 2 as documented here:
https://github.com/willnickols/maaslin3_benchmark. SparseDOSSA 2 uses
a zero-inflated log-linear abundance model to generate microbiome profiles
based on user-defined metadata and effect sizes. This procedure was modified
to record the total absolute abundance before
transforming the feature table to relative abundances.

No licenses are required or provided.
